/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.entity;

import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.betterend.registry.EndBiomes;
import org.betterx.betterend.registry.EndItems;

public class EndFishEntity
extends AbstractSchoolingFish {
    public static final int VARIANTS_NORMAL = 5;
    public static final int VARIANTS_SULPHUR = 3;
    public static final int VARIANTS = 8;
    private static final EntityDataAccessor<Byte> VARIANT = SynchedEntityData.m_135353_(EndFishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> SCALE = SynchedEntityData.m_135353_(EndFishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public EndFishEntity(EntityType<EndFishEntity> entityType, Level world) {
        super(entityType, world);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, SpawnGroupData entityData, CompoundTag entityTag) {
        SpawnGroupData data = super.m_6518_(world, difficulty, spawnReason, entityData, entityTag);
        BCLBiome biome = BiomeAPI.getBiome((Holder)world.m_204166_(this.m_20183_()));
        if (!BCLBiomeRegistry.isEmptyBiome((BCLBiome)biome) && biome.equals(EndBiomes.SULPHUR_SPRINGS)) {
            this.f_19804_.m_135381_(VARIANT, (Object)((byte)(this.f_19796_.m_188503_(3) + 5)));
        }
        if (entityTag != null) {
            if (entityTag.m_128441_("Variant")) {
                this.f_19804_.m_135381_(VARIANT, (Object)entityTag.m_128445_("variant"));
            }
            if (entityTag.m_128441_("Scale")) {
                this.f_19804_.m_135381_(SCALE, (Object)entityTag.m_128445_("scale"));
            }
        }
        this.m_6210_();
        return data;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)((byte)this.m_217043_().m_188503_(5)));
        this.f_19804_.m_135372_(SCALE, (Object)((byte)this.m_217043_().m_188503_(16)));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128344_("Variant", (byte)this.getVariant());
        tag.m_128344_("Scale", this.getByteScale());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            this.f_19804_.m_135381_(VARIANT, (Object)tag.m_128445_("Variant"));
        }
        if (tag.m_128441_("Scale")) {
            this.f_19804_.m_135381_(SCALE, (Object)tag.m_128445_("Scale"));
        }
    }

    public ItemStack m_28282_() {
        ItemStack bucket = EndItems.BUCKET_END_FISH.m_7968_();
        CompoundTag tag = bucket.m_41784_();
        tag.m_128344_("variant", ((Byte)this.f_19804_.m_135370_(VARIANT)).byteValue());
        tag.m_128344_("scale", ((Byte)this.f_19804_.m_135370_(SCALE)).byteValue());
        return bucket;
    }

    protected SoundEvent m_5699_() {
        return SoundEvents.f_12528_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12327_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12328_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12330_;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19796_.m_188503_(8) == 0 && this.m_146900_().m_60713_(Blocks.f_49990_)) {
            double x = this.m_20185_() + this.f_19796_.m_188583_() * 0.2;
            double y = this.m_20186_() + this.f_19796_.m_188583_() * 0.2;
            double z = this.m_20189_() + this.f_19796_.m_188583_() * 0.2;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22279_, 0.75);
    }

    public int getVariant() {
        return ((Byte)this.f_19804_.m_135370_(VARIANT)).byteValue();
    }

    public byte getByteScale() {
        return (Byte)this.f_19804_.m_135370_(SCALE);
    }

    public float m_6134_() {
        return (float)this.getByteScale() / 32.0f + 0.75f;
    }

    protected void m_7625_(DamageSource source, boolean causedByPlayer) {
        ItemStack handItem;
        Item item;
        Item item2 = item = source.m_269533_(DamageTypeTags.f_268745_) ? EndItems.END_FISH_COOKED : EndItems.END_FISH_RAW;
        if (causedByPlayer && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)(handItem = ((Player)source.m_7639_()).m_21120_(InteractionHand.MAIN_HAND))) > 0) {
            item = EndItems.END_FISH_COOKED;
        }
        ItemEntity drop = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)item));
        this.m_9236_().m_7967_((Entity)drop);
    }
}

