/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.complexmaterials;

import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.material.MapColor;
import org.betterx.bclib.blocks.BaseBlock;
import org.betterx.bclib.blocks.BaseButtonBlock;
import org.betterx.bclib.blocks.BaseFurnaceBlock;
import org.betterx.bclib.blocks.BasePressurePlateBlock;
import org.betterx.bclib.blocks.BaseRotatedPillarBlock;
import org.betterx.bclib.blocks.BaseSlabBlock;
import org.betterx.bclib.blocks.BaseStairsBlock;
import org.betterx.bclib.blocks.BaseWallBlock;
import org.betterx.bclib.recipes.BCLRecipeBuilder;
import org.betterx.bclib.recipes.StonecutterRecipeBuilder;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.blocks.EndPedestal;
import org.betterx.betterend.blocks.FlowerPotBlock;
import org.betterx.betterend.blocks.basis.StoneLanternBlock;
import org.betterx.betterend.recipe.CraftingRecipes;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndItems;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;
import org.betterx.worlds.together.tag.v3.CommonItemTags;
import org.betterx.worlds.together.tag.v3.TagManager;

public class StoneMaterial {
    public final Block stone;
    public final String baseName;
    public final Block polished;
    public final Block tiles;
    public final Block pillar;
    public final Block stairs;
    public final Block slab;
    public final Block wall;
    public final Block button;
    public final Block pressurePlate;
    public final Block pedestal;
    public final Block lantern;
    public final Block bricks;
    public final Block brickStairs;
    public final Block brickSlab;
    public final Block brickWall;
    public final Block furnace;
    public final Block flowerPot;

    public static FabricBlockSettings createMaterial(MapColor color) {
        return FabricBlockSettings.copyOf((BlockBehaviour)Blocks.f_50259_).mapColor(color);
    }

    public StoneMaterial(String name, MapColor color) {
        FabricBlockSettings material = StoneMaterial.createMaterial(color);
        this.baseName = name;
        this.stone = EndBlocks.registerBlock(name, (Block)new BaseBlock.Stone((BlockBehaviour.Properties)material), new TagKey[0]);
        this.polished = EndBlocks.registerBlock(name + "_polished", (Block)new BaseBlock.Stone((BlockBehaviour.Properties)material), new TagKey[0]);
        this.tiles = EndBlocks.registerBlock(name + "_tiles", (Block)new BaseBlock.Stone((BlockBehaviour.Properties)material), new TagKey[0]);
        this.pillar = EndBlocks.registerBlock(name + "_pillar", (Block)new BaseRotatedPillarBlock.Stone((BlockBehaviour.Properties)material), new TagKey[0]);
        this.stairs = EndBlocks.registerBlock(name + "_stairs", (Block)new BaseStairsBlock.Stone(this.stone), new TagKey[0]);
        this.slab = EndBlocks.registerBlock(name + "_slab", (Block)new BaseSlabBlock.Stone(this.stone), new TagKey[0]);
        this.wall = EndBlocks.registerBlock(name + "_wall", (Block)new BaseWallBlock.Stone(this.stone), new TagKey[0]);
        this.button = EndBlocks.registerBlock(name + "_button", (Block)new BaseButtonBlock.Stone(this.stone, BlockSetType.f_271479_), new TagKey[0]);
        this.pressurePlate = EndBlocks.registerBlock(name + "_plate", (Block)new BasePressurePlateBlock.Stone(this.stone, BlockSetType.f_271479_), new TagKey[0]);
        this.pedestal = EndBlocks.registerBlock(name + "_pedestal", (Block)new EndPedestal.Stone(this.stone), new TagKey[0]);
        this.lantern = EndBlocks.registerBlock(name + "_lantern", (Block)new StoneLanternBlock(this.stone), new TagKey[0]);
        this.bricks = EndBlocks.registerBlock(name + "_bricks", (Block)new BaseBlock.Stone((BlockBehaviour.Properties)material), new TagKey[0]);
        this.brickStairs = EndBlocks.registerBlock(name + "_bricks_stairs", (Block)new BaseStairsBlock.Stone(this.bricks), new TagKey[0]);
        this.brickSlab = EndBlocks.registerBlock(name + "_bricks_slab", (Block)new BaseSlabBlock.Stone(this.bricks), new TagKey[0]);
        this.brickWall = EndBlocks.registerBlock(name + "_bricks_wall", (Block)new BaseWallBlock.Stone(this.bricks), new TagKey[0]);
        this.furnace = EndBlocks.registerBlock(name + "_furnace", (Block)new BaseFurnaceBlock.Stone(this.bricks), new TagKey[0]);
        this.flowerPot = EndBlocks.registerBlock(name + "_flower_pot", (Block)new FlowerPotBlock.Stone(this.bricks), new TagKey[0]);
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_bricks"), (ItemLike)this.bricks).setOutputCount(4).setShape(new String[]{"##", "##"}).addMaterial('#', new ItemLike[]{this.stone}).setGroup("end_bricks").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_polished"), (ItemLike)this.polished).setOutputCount(4).setShape(new String[]{"##", "##"}).addMaterial('#', new ItemLike[]{this.bricks}).setGroup("end_tile").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_tiles"), (ItemLike)this.tiles).setOutputCount(4).setShape(new String[]{"##", "##"}).addMaterial('#', new ItemLike[]{this.polished}).setGroup("end_small_tile").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_pillar"), (ItemLike)this.pillar).setShape(new String[]{"#", "#"}).addMaterial('#', new ItemLike[]{this.slab}).setGroup("end_pillar").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_stairs"), (ItemLike)this.stairs).setOutputCount(4).setShape(new String[]{"#  ", "## ", "###"}).addMaterial('#', new ItemLike[]{this.stone}).setGroup("end_stone_stairs").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_slab"), (ItemLike)this.slab).setOutputCount(6).setShape(new String[]{"###"}).addMaterial('#', new ItemLike[]{this.stone}).setGroup("end_stone_slabs").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_bricks_stairs"), (ItemLike)this.brickStairs).setOutputCount(4).setShape(new String[]{"#  ", "## ", "###"}).addMaterial('#', new ItemLike[]{this.bricks}).setGroup("end_stone_stairs").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_bricks_slab"), (ItemLike)this.brickSlab).setOutputCount(6).setShape(new String[]{"###"}).addMaterial('#', new ItemLike[]{this.bricks}).setGroup("end_stone_slabs").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_wall"), (ItemLike)this.wall).setOutputCount(6).setShape(new String[]{"###", "###"}).addMaterial('#', new ItemLike[]{this.stone}).setGroup("end_wall").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_bricks_wall"), (ItemLike)this.brickWall).setOutputCount(6).setShape(new String[]{"###", "###"}).addMaterial('#', new ItemLike[]{this.bricks}).setGroup("end_wall").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_button"), (ItemLike)this.button).shapeless().addMaterial('#', new ItemLike[]{this.stone}).setGroup("end_stone_buttons").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_pressure_plate"), (ItemLike)this.pressurePlate).setShape(new String[]{"##"}).addMaterial('#', new ItemLike[]{this.stone}).setGroup("end_stone_plates").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_lantern"), (ItemLike)this.lantern).setShape(new String[]{"S", "#", "S"}).addMaterial('#', new ItemLike[]{EndItems.CRYSTAL_SHARDS}).addMaterial('S', new ItemLike[]{this.slab, this.brickSlab}).setGroup("end_stone_lanterns").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_furnace"), (ItemLike)this.furnace).setShape(new String[]{"###", "# #", "###"}).addMaterial('#', new ItemLike[]{this.stone}).setGroup("end_stone_ITEM_FURNACES").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_flower_pot"), (ItemLike)this.flowerPot).setOutputCount(3).setShape(new String[]{"# #", " # "}).addMaterial('#', new ItemLike[]{this.bricks}).setGroup("end_pots").build();
        CraftingRecipes.registerPedestal(name + "_pedestal", this.pedestal, this.slab, this.pillar);
        StoneMaterial.recipesForStoneMaterial(this);
        TagManager.ITEMS.add(ItemTags.f_13139_, (Object[])new Item[]{this.slab.m_5456_(), this.brickSlab.m_5456_()});
        TagManager.ITEMS.add(ItemTags.f_13169_, (Object[])new Item[]{this.bricks.m_5456_()});
        TagManager.ITEMS.add(ItemTags.f_13166_, (Object[])new Item[]{this.stone.m_5456_()});
        TagManager.ITEMS.add(ItemTags.f_13165_, (Object[])new Item[]{this.stone.m_5456_()});
        TagManager.ITEMS.add(CommonItemTags.FURNACES, (Object[])new Item[]{this.furnace.m_5456_()});
        TagManager.BLOCKS.add(BlockTags.f_13091_, (Object[])new Block[]{this.bricks});
        TagManager.BLOCKS.add(BlockTags.f_13032_, (Object[])new Block[]{this.wall, this.brickWall});
        TagManager.BLOCKS.add(BlockTags.f_13031_, (Object[])new Block[]{this.slab, this.brickSlab});
        TagManager.BLOCKS.add((Object)this.pressurePlate, new TagKey[]{BlockTags.f_13099_, BlockTags.f_13101_});
        TagManager.BLOCKS.add(CommonBlockTags.END_STONES, (Object[])new Block[]{this.stone});
        TagManager.BLOCKS.add(BlockTags.f_13069_, (Object[])new Block[]{this.stone, this.stairs, this.slab, this.wall});
        TagManager.BLOCKS.add(CommonBlockTags.END_STONES, (Object[])new Block[]{this.stone});
        TagManager.BLOCKS.add(CommonBlockTags.END_STONES, (Object[])new Block[]{this.stone});
    }

    public static void recipesForStoneMaterial(StoneMaterial mat) {
        ((StonecutterRecipeBuilder)BCLRecipeBuilder.stonecutting((ResourceLocation)BetterEnd.makeID(mat.baseName + "_bricks_stonecutting"), (ItemLike)mat.bricks).setPrimaryInputAndUnlock(new ItemLike[]{mat.stone})).setGroup(mat.baseName + "_stonecutting").build();
        ((StonecutterRecipeBuilder)BCLRecipeBuilder.stonecutting((ResourceLocation)BetterEnd.makeID(mat.baseName + "_wall_stonecutting"), (ItemLike)mat.wall).setPrimaryInputAndUnlock(new ItemLike[]{mat.stone})).setGroup(mat.baseName + "_stonecutting").build();
        ((StonecutterRecipeBuilder)BCLRecipeBuilder.stonecutting((ResourceLocation)BetterEnd.makeID(mat.baseName + "_slab_stonecutting"), (ItemLike)mat.slab).setPrimaryInputAndUnlock(new ItemLike[]{mat.stone})).setGroup(mat.baseName + "_stonecutting").build();
        ((StonecutterRecipeBuilder)BCLRecipeBuilder.stonecutting((ResourceLocation)BetterEnd.makeID(mat.baseName + "_stairs_stonecutting"), (ItemLike)mat.stairs).setPrimaryInputAndUnlock(new ItemLike[]{mat.stone})).setGroup(mat.baseName + "_stonecutting").build();
        ((StonecutterRecipeBuilder)BCLRecipeBuilder.stonecutting((ResourceLocation)BetterEnd.makeID(mat.baseName + "_tiles_stonecutting"), (ItemLike)mat.tiles).setPrimaryInputAndUnlock(new ItemLike[]{mat.stone})).setGroup(mat.baseName + "_stonecutting").build();
        ((StonecutterRecipeBuilder)BCLRecipeBuilder.stonecutting((ResourceLocation)BetterEnd.makeID(mat.baseName + "_brick_slab_stonecutting"), (ItemLike)mat.brickSlab).setOutputCount(2).setPrimaryInputAndUnlock(new ItemLike[]{mat.stone})).setGroup(mat.baseName + "_stonecutting").build();
        ((StonecutterRecipeBuilder)BCLRecipeBuilder.stonecutting((ResourceLocation)BetterEnd.makeID(mat.baseName + "_brick_stair_stonecutting"), (ItemLike)mat.brickStairs).setPrimaryInputAndUnlock(new ItemLike[]{mat.stone})).setGroup(mat.baseName + "_stonecutting").build();
        ((StonecutterRecipeBuilder)BCLRecipeBuilder.stonecutting((ResourceLocation)BetterEnd.makeID(mat.baseName + "_brick_wall_stonecutting"), (ItemLike)mat.brickWall).setPrimaryInputAndUnlock(new ItemLike[]{mat.stone})).setGroup(mat.baseName + "_stonecutting").build();
        ((StonecutterRecipeBuilder)BCLRecipeBuilder.stonecutting((ResourceLocation)BetterEnd.makeID(mat.baseName + "_pillar_stonecutting"), (ItemLike)mat.pillar).setPrimaryInputAndUnlock(new ItemLike[]{mat.stone})).setGroup(mat.baseName + "_stonecutting").build();
        ((StonecutterRecipeBuilder)BCLRecipeBuilder.stonecutting((ResourceLocation)BetterEnd.makeID(mat.baseName + "_polished_stonecutting"), (ItemLike)mat.polished).setPrimaryInputAndUnlock(new ItemLike[]{mat.stone})).setGroup(mat.baseName + "_stonecutting").build();
        ((StonecutterRecipeBuilder)BCLRecipeBuilder.stonecutting((ResourceLocation)BetterEnd.makeID(mat.baseName + "_brick_slabs_from_" + mat.baseName + "_brick_stonecutting"), (ItemLike)mat.brickSlab).setOutputCount(2).setPrimaryInputAndUnlock(new ItemLike[]{mat.bricks})).setGroup(mat.baseName + "_stonecutting").build();
        ((StonecutterRecipeBuilder)BCLRecipeBuilder.stonecutting((ResourceLocation)BetterEnd.makeID(mat.baseName + "_brick_stair_from_" + mat.baseName + "_brick_stonecutting"), (ItemLike)mat.brickStairs).setPrimaryInputAndUnlock(new ItemLike[]{mat.bricks})).setGroup(mat.baseName + "_stonecutting").build();
        ((StonecutterRecipeBuilder)BCLRecipeBuilder.stonecutting((ResourceLocation)BetterEnd.makeID(mat.baseName + "_brick_wall_from_" + mat.baseName + "_brick_stonecutting"), (ItemLike)mat.brickWall).setPrimaryInputAndUnlock(new ItemLike[]{mat.bricks})).setGroup(mat.baseName + "_stonecutting").build();
    }
}

