/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.complexmaterials;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import org.betterx.bclib.recipes.BCLRecipeBuilder;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.registry.EndBlocks;

public class ColoredMaterial {
    private static final Map<Integer, ItemLike> DYES = Maps.newHashMap();
    private static final Map<Integer, String> COLORS = Maps.newHashMap();
    private final Map<Integer, Block> colors = Maps.newHashMap();

    public ColoredMaterial(Function<FabricBlockSettings, Block> constructor, Block source, boolean craftEight) {
        this(constructor, source, COLORS, DYES, craftEight);
    }

    public ColoredMaterial(Function<FabricBlockSettings, Block> constructor, Block source, Map<Integer, String> colors, Map<Integer, ItemLike> dyes, boolean craftEight) {
        String id = BuiltInRegistries.f_256975_.m_7981_((Object)source).m_135815_();
        colors.forEach((color, name) -> {
            String blockName = id + "_" + name;
            Block block = (Block)constructor.apply(FabricBlockSettings.copyOf((BlockBehaviour)source).mapColor(MapColor.f_283927_));
            EndBlocks.registerBlock(blockName, block, new TagKey[0]);
            if (craftEight) {
                BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(blockName), (ItemLike)block).setOutputCount(8).setShape(new String[]{"###", "#D#", "###"}).addMaterial('#', new ItemLike[]{source}).addMaterial('D', new ItemLike[]{(ItemLike)dyes.get(color)}).build();
            } else {
                BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(blockName), (ItemLike)block).setList("#D").addMaterial('#', new ItemLike[]{source}).addMaterial('D', new ItemLike[]{(ItemLike)dyes.get(color)}).build();
            }
            this.colors.put((Integer)color, block);
            BlocksHelper.addBlockColor((Block)block, (int)color);
        });
    }

    public Block getByColor(DyeColor color) {
        return this.colors.get(color.m_284406_().f_283871_);
    }

    public Block getByColor(int color) {
        return this.colors.get(color);
    }

    static {
        for (DyeColor color : DyeColor.values()) {
            int colorRGB = color.m_284406_().f_283871_;
            COLORS.put(colorRGB, color.m_41065_());
            DYES.put(colorRGB, (ItemLike)DyeItem.m_41082_((DyeColor)color));
        }
    }
}

