/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.commands;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.LocateCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.poi.BCLPoiType;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.registry.EndPoiTypes;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.worlds.together.world.event.WorldBootstrap;
import org.joml.Vector3d;

public class CommandRegistry {
    private static int biomeIndex = 0;
    private static final int MAX_SEARCH_RADIUS = 12800;
    private static final int SAMPLE_RESOLUTION_HORIZONTAL = 32;
    private static final int SAMPLE_RESOLUTION_VERTICAL = 64;
    private static final DynamicCommandExceptionType ERROR_BIOME_NOT_FOUND = new DynamicCommandExceptionType(object -> Component.m_237113_((String)("The next biome (" + object + ") was not found.")));

    public static void register() {
        CommandRegistrationCallback.EVENT.register(CommandRegistry::register);
    }

    private static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection commandSelection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"be").requires(source -> source.m_6761_(4))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"locate_portal").requires(source -> source.m_6761_(4))).executes(ctx -> CommandRegistry.find_poi((CommandContext<CommandSourceStack>)ctx, EndPoiTypes.ETERNAL_PORTAL)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"locate_portal_frame").requires(source -> source.m_6761_(4))).executes(ctx -> CommandRegistry.find_poi((CommandContext<CommandSourceStack>)ctx, EndPoiTypes.ETERNAL_PORTAL_FRAME)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"tpnext").requires(source -> source.m_6761_(4))).executes(CommandRegistry::teleportToNextBiome)));
    }

    private static int find_poi(CommandContext<CommandSourceStack> ctx, BCLPoiType poi) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = source.m_81375_();
        Vec3 pos = source.m_81371_();
        ServerLevel level = source.m_81372_();
        BlockPos.MutableBlockPos mPos = new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_).m_122032_();
        System.out.println("Searching POI: " + poi.key);
        Optional found = poi.findPoiAround(level, (BlockPos)mPos, false, level.m_6857_());
        System.out.println("Found at: " + found.orElse(null));
        if (found.isPresent()) {
            BlocksHelper.setWithoutUpdate((LevelAccessor)level, (BlockPos)((BlockPos)found.get()), (Block)Blocks.f_50494_);
            BlocksHelper.setWithoutUpdate((LevelAccessor)level, (BlockPos)mPos, (Block)Blocks.f_50545_);
        } else {
            BlocksHelper.setWithoutUpdate((LevelAccessor)level, (BlockPos)mPos, (Block)Blocks.f_50504_);
        }
        return 1;
    }

    private static int teleportToNextBiome(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        BlockPos target;
        BlockState state;
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        List<BCLBiome> biomes = EndBiome.getAllBeBiomes();
        if (biomeIndex < 0 || biomeIndex >= biomes.size()) {
            source.m_81352_((Component)Component.m_237113_((String)"Failed to find the next Biome...").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            return 0;
        }
        final BCLBiome biome = biomes.get(biomeIndex);
        source.m_288197_(() -> Component.m_237113_((String)("Locating Biome " + biome)).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
        biomeIndex = (biomeIndex + 1) % biomes.size();
        BlockPos currentPosition = new BlockPos((int)source.m_81371_().f_82479_, (int)source.m_81371_().f_82480_, (int)source.m_81371_().f_82481_);
        BlockPos biomePosition = (BlockPos)source.m_81372_().m_215069_(b -> ((ResourceKey)b.m_203543_().orElseThrow()).m_135782_().equals((Object)biome.getID()), currentPosition, 12800, 32, 64).getFirst();
        final String biomeName = biome.toString();
        if (biomePosition == null) {
            throw ERROR_BIOME_NOT_FOUND.create((Object)biomeName);
        }
        ServerPlayer player = source.m_81375_();
        double yPos = source.m_81371_().m_7098_();
        boolean didWrap = false;
        do {
            target = new BlockPos(biomePosition.m_123341_(), (int)yPos, biomePosition.m_123343_());
            state = player.m_9236_().m_8055_(target);
            if (!((yPos -= 1.0) <= (double)(player.m_9236_().m_141937_() + 1))) continue;
            if (didWrap) break;
            yPos = 127.0;
            didWrap = true;
        } while (!state.m_60795_() && yPos > (double)player.m_9236_().m_141937_() && yPos < (double)player.m_9236_().m_151558_());
        Vector3d targetPlayerPos = new Vector3d((double)target.m_123341_() + 0.5, (double)(target.m_123342_() - 1), (double)target.m_123343_() + 0.5);
        player.f_8906_.m_9780_(targetPlayerPos.x, targetPlayerPos.y, targetPlayerPos.z, 0.0f, 0.0f, Collections.EMPTY_SET);
        ResourceOrTagKeyArgument.Result result = new ResourceOrTagKeyArgument.Result(){

            public Either<ResourceKey, TagKey> m_245276_() {
                return Either.left((Object)biome.getBiomeKey());
            }

            public Optional<ResourceOrTagKeyArgument.Result> m_245137_(ResourceKey resourceKey) {
                return Optional.empty();
            }

            public String m_245390_() {
                return biomeName;
            }

            public boolean test(Object o) {
                return false;
            }
        };
        ResourceKey a = biome.getBiomeKey();
        if (WorldBootstrap.getLastRegistryAccess() != null) {
            Stopwatch stopwatch = Stopwatch.createStarted((Ticker)Util.f_211544_);
            Holder h = (Holder)WorldBootstrap.getLastRegistryAccess().m_175515_(Registries.f_256952_).m_203636_(a).orElseThrow();
            stopwatch.stop();
            return LocateCommand.m_262810_((CommandSourceStack)source, (ResourceOrTagKeyArgument.Result)result, (BlockPos)currentPosition, (Pair)new Pair((Object)biomePosition, (Object)h), (String)"commands.locatebiome.success", (boolean)false, (Duration)stopwatch.elapsed());
        }
        return 1;
    }
}

