/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.client.gui;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import org.anti_ad.mc.ipn.api.IPNIgnore;
import org.betterx.bclib.recipes.AlloyingRecipe;
import org.betterx.betterend.blocks.entities.EndStoneSmelterBlockEntity;
import org.betterx.betterend.client.gui.slot.SmelterFuelSlot;
import org.betterx.betterend.client.gui.slot.SmelterOutputSlot;
import org.betterx.betterend.registry.EndMenuTypes;

@IPNIgnore
public class EndStoneSmelterMenu
extends RecipeBookMenu<Container> {
    public static final int INGREDIENT_SLOT_A = 0;
    public static final int INGREDIENT_SLOT_B = 1;
    public static final int FUEL_SLOT = 2;
    public static final int RESULT_SLOT = 3;
    public static final int SLOT_COUNT = 4;
    private static final int INV_SLOT_START = 4;
    private static final int INV_SLOT_END = 31;
    private static final int USE_ROW_SLOT_START = 31;
    private static final int USE_ROW_SLOT_END = 40;
    private final Container inventory;
    private final ContainerData propertyDelegate;
    protected final Level world;

    public EndStoneSmelterMenu(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(4), (ContainerData)new SimpleContainerData(4));
    }

    public EndStoneSmelterMenu(int syncId, Inventory playerInventory, Container inventory, ContainerData propertyDelegate) {
        super(EndMenuTypes.END_STONE_SMELTER, syncId);
        int i;
        this.inventory = inventory;
        this.propertyDelegate = propertyDelegate;
        this.world = playerInventory.f_35978_.m_9236_();
        this.m_38884_(propertyDelegate);
        this.m_38897_(new Slot(inventory, 0, 45, 17));
        this.m_38897_(new Slot(inventory, 1, 67, 17));
        this.m_38897_(new SmelterFuelSlot(this, inventory, 2, 56, 53));
        this.m_38897_(new SmelterOutputSlot(playerInventory.f_35978_, inventory, 3, 129, 35));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public MenuType<?> m_6772_() {
        return EndMenuTypes.END_STONE_SMELTER;
    }

    public void m_5816_(StackedContents finder) {
        if (this.inventory instanceof StackedContentsCompatible) {
            ((StackedContentsCompatible)this.inventory).m_5809_(finder);
        }
    }

    public void m_6650_() {
        this.m_38853_(0).m_5852_(ItemStack.f_41583_);
        this.m_38853_(1).m_5852_(ItemStack.f_41583_);
        this.m_38853_(3).m_5852_(ItemStack.f_41583_);
    }

    public boolean m_6032_(Recipe<? super Container> recipe) {
        return recipe.m_5818_(this.inventory, this.world);
    }

    public int m_6636_() {
        return 3;
    }

    public int m_6635_() {
        return 2;
    }

    public int m_6656_() {
        return 1;
    }

    public int m_6653_() {
        return 4;
    }

    public RecipeBookType m_5867_() {
        return RecipeBookType.BLAST_FURNACE;
    }

    public boolean m_142157_(int i) {
        return i != 2;
    }

    public boolean m_6875_(Player player) {
        return this.inventory.m_6542_(player);
    }

    protected boolean isSmeltable(ItemStack itemStack) {
        return this.world.m_7465_().m_44015_(AlloyingRecipe.TYPE, (Container)new SimpleContainer(new ItemStack[]{itemStack}), this.world).isPresent();
    }

    public boolean isFuel(ItemStack itemStack) {
        return EndStoneSmelterBlockEntity.canUseAsFuel(itemStack);
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot == null || !slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack slotStack = slot.m_7993_();
        ItemStack itemStack = slotStack.m_41777_();
        if (index == 3) {
            if (!this.m_38903_(slotStack, 4, 40, true)) {
                return ItemStack.f_41583_;
            }
            slot.m_40234_(slotStack, itemStack);
        } else if (index == 2 || index == 0 || index == 1 ? !this.m_38903_(slotStack, 31, 40, false) : (this.isSmeltable(slotStack) ? !this.m_38903_(slotStack, 0, 2, false) : (this.isFuel(slotStack) ? !this.m_38903_(slotStack, 2, 3, false) : (index >= 4 && index < 31 ? !this.m_38903_(slotStack, 31, 40, false) : index >= 31 && index < 40 && !this.m_38903_(slotStack, 4, 31, false))))) {
            return ItemStack.f_41583_;
        }
        if (slotStack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (slotStack.m_41613_() == itemStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, slotStack);
        return itemStack;
    }

    @Environment(value=EnvType.CLIENT)
    public int getSmeltProgress() {
        int time = this.propertyDelegate.m_6413_(2);
        int timeTotal = this.propertyDelegate.m_6413_(3);
        return timeTotal != 0 && time != 0 ? time * 24 / timeTotal : 0;
    }

    @Environment(value=EnvType.CLIENT)
    public int getFuelProgress() {
        int fuelTime = this.propertyDelegate.m_6413_(1);
        if (fuelTime == 0) {
            fuelTime = 200;
        }
        return this.propertyDelegate.m_6413_(0) * 13 / fuelTime;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean isBurning() {
        return this.propertyDelegate.m_6413_(0) > 0;
    }
}

