/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks.entities;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.betterx.bclib.recipes.AlloyingRecipe;
import org.betterx.betterend.blocks.EndStoneSmelter;
import org.betterx.betterend.client.gui.EndStoneSmelterMenu;
import org.betterx.betterend.registry.EndBlockEntities;

public class EndStoneSmelterBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeHolder,
StackedContentsCompatible {
    private static final int[] TOP_SLOTS = new int[]{0, 1};
    private static final int[] BOTTOM_SLOTS = new int[]{2, 3};
    private static final int[] SIDE_SLOTS = new int[]{2};
    private static final Map<Item, Integer> AVAILABLE_FUELS = Maps.newHashMap();
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed;
    protected NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    protected final ContainerData propertyDelegate;
    private Recipe<?> lastRecipe;
    private int smeltTimeTotal;
    private int smeltTime;
    private int burnTime;
    private int fuelTime;

    public EndStoneSmelterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EndBlockEntities.END_STONE_SMELTER, blockPos, blockState);
        this.recipesUsed = new Object2IntOpenHashMap();
        this.propertyDelegate = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> EndStoneSmelterBlockEntity.this.burnTime;
                    case 1 -> EndStoneSmelterBlockEntity.this.fuelTime;
                    case 2 -> EndStoneSmelterBlockEntity.this.smeltTime;
                    case 3 -> EndStoneSmelterBlockEntity.this.smeltTimeTotal;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        EndStoneSmelterBlockEntity.this.burnTime = value;
                        break;
                    }
                    case 1: {
                        EndStoneSmelterBlockEntity.this.fuelTime = value;
                        break;
                    }
                    case 2: {
                        EndStoneSmelterBlockEntity.this.smeltTime = value;
                        break;
                    }
                    case 3: {
                        EndStoneSmelterBlockEntity.this.smeltTimeTotal = value;
                    }
                }
            }

            public int m_6499_() {
                return 4;
            }
        };
    }

    private boolean isBurning() {
        return this.burnTime > 0;
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public boolean m_7983_() {
        ItemStack itemStack;
        Iterator iterator = this.inventory.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((itemStack = (ItemStack)iterator.next()).m_41619_());
        return false;
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return ContainerHelper.m_18969_(this.inventory, (int)slot, (int)amount);
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.inventory, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        ItemStack itemStack = (ItemStack)this.inventory.get(slot);
        boolean stackValid = !stack.m_41619_() && ItemStack.m_41656_((ItemStack)stack, (ItemStack)itemStack) && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack);
        this.inventory.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (!(slot != 0 && slot != 1 || stackValid)) {
            this.smeltTimeTotal = this.getSmeltTime();
            this.smeltTime = 0;
            this.m_6596_();
        }
    }

    protected int getSmeltTime() {
        if (this.f_58857_ == null) {
            return 200;
        }
        int smeltTime = this.f_58857_.m_7465_().m_44015_(AlloyingRecipe.TYPE, (Container)this, this.f_58857_).map(AlloyingRecipe::getSmeltTime).orElse(0);
        if (smeltTime == 0) {
            smeltTime = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44109_, (Container)this, this.f_58857_).map(AbstractCookingRecipe::m_43753_).orElse(200);
            smeltTime = (int)((double)smeltTime / 1.5);
        }
        return smeltTime;
    }

    public void dropExperience(Player player) {
        if (this.f_58857_ == null) {
            return;
        }
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            this.f_58857_.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                if (recipe instanceof AlloyingRecipe) {
                    AlloyingRecipe alloying = (AlloyingRecipe)recipe;
                    this.dropExperience(player.m_9236_(), player.m_20182_(), entry.getIntValue(), alloying.getExperience());
                } else {
                    BlastingRecipe blasting = (BlastingRecipe)recipe;
                    this.dropExperience(player.m_9236_(), player.m_20182_(), entry.getIntValue(), blasting.m_43750_());
                }
            });
        }
        player.m_7281_((Collection)list);
        this.recipesUsed.clear();
    }

    private void dropExperience(Level world, Vec3 vec3d, int count, float amount) {
        int expTotal = Mth.m_14143_((float)((float)count * amount));
        float g = Mth.m_14187_((float)((float)count * amount));
        if (g != 0.0f && Math.random() < (double)g) {
            ++expTotal;
        }
        while (expTotal > 0) {
            int expVal = ExperienceOrb.m_20782_((int)expTotal);
            expTotal -= expVal;
            world.m_7967_((Entity)new ExperienceOrb(world, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, expVal));
        }
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_ != null && this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)String.format("block.%s.%s", "betterend", "end_stone_smelter"));
    }

    protected AbstractContainerMenu m_6555_(int syncId, Inventory playerInventory) {
        return new EndStoneSmelterMenu(syncId, playerInventory, (Container)this, this.propertyDelegate);
    }

    public static void tick(Level tickLevel, BlockPos tickPos, BlockState tickState, EndStoneSmelterBlockEntity blockEntity) {
        if (tickLevel == null) {
            return;
        }
        boolean initialBurning = blockEntity.isBurning();
        if (initialBurning) {
            --blockEntity.burnTime;
        }
        boolean burning = initialBurning;
        if (!tickLevel.f_46443_) {
            ItemStack fuel = (ItemStack)blockEntity.inventory.get(2);
            if (!burning && (fuel.m_41619_() || ((ItemStack)blockEntity.inventory.get(0)).m_41619_() && ((ItemStack)blockEntity.inventory.get(1)).m_41619_())) {
                if (blockEntity.smeltTime > 0) {
                    blockEntity.smeltTime = Mth.m_14045_((int)(blockEntity.smeltTime - 2), (int)0, (int)blockEntity.smeltTimeTotal);
                }
            } else {
                Recipe recipe = tickLevel.m_7465_().m_44015_(AlloyingRecipe.TYPE, (Container)blockEntity, tickLevel).orElse(null);
                if (recipe == null) {
                    recipe = tickLevel.m_7465_().m_44015_(RecipeType.f_44109_, (Container)blockEntity, tickLevel).orElse(null);
                }
                boolean accepted = blockEntity.canAcceptRecipeOutput(recipe, tickLevel.m_9598_());
                if (!burning && accepted) {
                    blockEntity.fuelTime = blockEntity.burnTime = EndStoneSmelterBlockEntity.getFuelTime(fuel);
                    burning = blockEntity.isBurning();
                    if (burning) {
                        if (!fuel.m_41619_()) {
                            Item item = fuel.m_41720_();
                            fuel.m_41774_(1);
                            if (fuel.m_41619_()) {
                                Item remainFuel = item.m_41469_();
                                blockEntity.inventory.set(2, (Object)(remainFuel == null ? ItemStack.f_41583_ : new ItemStack((ItemLike)remainFuel)));
                            }
                        }
                        blockEntity.m_6596_();
                    }
                }
                if (burning && accepted) {
                    ++blockEntity.smeltTime;
                    if (blockEntity.smeltTime == blockEntity.smeltTimeTotal) {
                        blockEntity.smeltTime = 0;
                        blockEntity.smeltTimeTotal = blockEntity.getSmeltTime();
                        blockEntity.craftRecipe(recipe, tickLevel.m_9598_());
                        blockEntity.m_6596_();
                    }
                } else {
                    blockEntity.smeltTime = 0;
                }
            }
            if (initialBurning != (burning = blockEntity.isBurning())) {
                tickLevel.m_7731_(tickPos, (BlockState)tickState.m_61124_((Property)EndStoneSmelter.LIT, (Comparable)Boolean.valueOf(burning)), 3);
                blockEntity.m_6596_();
            }
        }
    }

    protected boolean canAcceptRecipeOutput(Recipe<?> recipe, RegistryAccess acc) {
        boolean validInput;
        if (recipe == null) {
            return false;
        }
        if (recipe instanceof AlloyingRecipe) {
            validInput = !((ItemStack)this.inventory.get(0)).m_41619_() && !((ItemStack)this.inventory.get(1)).m_41619_();
        } else {
            boolean bl = validInput = !((ItemStack)this.inventory.get(0)).m_41619_() || !((ItemStack)this.inventory.get(1)).m_41619_();
        }
        if (validInput) {
            ItemStack result = recipe.m_8043_(acc);
            if (result.m_41619_()) {
                return false;
            }
            ItemStack output = (ItemStack)this.inventory.get(3);
            int outCount = output.m_41613_();
            int total = outCount + result.m_41613_();
            if (output.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_41656_((ItemStack)output, (ItemStack)result)) {
                return false;
            }
            if (outCount < this.m_6893_() && outCount < output.m_41741_()) {
                return this.m_6893_() >= total;
            }
            return output.m_41613_() < result.m_41741_();
        }
        return false;
    }

    private void craftRecipe(Recipe<?> recipe, RegistryAccess acc) {
        if (recipe == null || !this.canAcceptRecipeOutput(recipe, acc)) {
            return;
        }
        ItemStack result = recipe.m_8043_(acc);
        ItemStack output = (ItemStack)this.inventory.get(3);
        if (output.m_41619_()) {
            this.inventory.set(3, (Object)result.m_41777_());
        } else if (output.m_41720_() == result.m_41720_()) {
            output.m_41769_(result.m_41613_());
        }
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_) {
            this.m_6029_(recipe);
        }
        if (recipe instanceof AlloyingRecipe) {
            ((ItemStack)this.inventory.get(0)).m_41774_(1);
            ((ItemStack)this.inventory.get(1)).m_41774_(1);
        } else if (!((ItemStack)this.inventory.get(0)).m_41619_()) {
            ((ItemStack)this.inventory.get(0)).m_41774_(1);
        } else {
            ((ItemStack)this.inventory.get(1)).m_41774_(1);
        }
    }

    public void m_5809_(StackedContents finder) {
        for (ItemStack itemStack : this.inventory) {
            finder.m_36491_(itemStack);
        }
    }

    public void m_6029_(Recipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation recipeId = recipe.m_6423_();
            this.recipesUsed.addTo((Object)recipeId, 1);
            this.lastRecipe = recipe;
        }
    }

    public Recipe<?> m_7928_() {
        return this.lastRecipe;
    }

    public int[] m_7071_(Direction side) {
        return switch (side) {
            case Direction.DOWN -> BOTTOM_SLOTS;
            case Direction.UP -> TOP_SLOTS;
            default -> SIDE_SLOTS;
        };
    }

    public boolean m_7155_(int slot, ItemStack stack, Direction dir) {
        return this.m_7013_(slot, stack);
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        if (dir == Direction.DOWN && slot == 2) {
            return stack.m_41720_() == Items.f_42446_;
        }
        return true;
    }

    public static int getFuelTime(ItemStack fuel) {
        if (fuel.m_41619_()) {
            return 0;
        }
        Item item = fuel.m_41720_();
        return AVAILABLE_FUELS.getOrDefault(item, EndStoneSmelterBlockEntity.getFabricFuel(fuel));
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.inventory);
        this.burnTime = tag.m_128448_("BurnTime");
        this.fuelTime = tag.m_128448_("FuelTime");
        this.smeltTime = tag.m_128448_("SmeltTime");
        this.smeltTimeTotal = tag.m_128448_("SmeltTimeTotal");
        CompoundTag compoundTag = tag.m_128469_("RecipesUsed");
        for (String id : compoundTag.m_128431_()) {
            this.recipesUsed.put((Object)new ResourceLocation(id), compoundTag.m_128451_(id));
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128376_("BurnTime", (short)this.burnTime);
        tag.m_128376_("FuelTime", (short)this.fuelTime);
        tag.m_128376_("SmeltTime", (short)this.smeltTime);
        tag.m_128376_("SmeltTimeTotal", (short)this.smeltTimeTotal);
        ContainerHelper.m_18973_((CompoundTag)tag, this.inventory);
        CompoundTag usedRecipes = new CompoundTag();
        this.recipesUsed.forEach((identifier, integer) -> usedRecipes.m_128405_(identifier.toString(), integer.intValue()));
        tag.m_128365_("RecipesUsed", (Tag)usedRecipes);
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        if (slot == 3) {
            return false;
        }
        if (slot != 2) {
            return true;
        }
        ItemStack itemStack = (ItemStack)this.inventory.get(2);
        return EndStoneSmelterBlockEntity.canUseAsFuel(stack) || stack.m_41720_() == Items.f_42446_ && itemStack.m_41720_() != Items.f_42446_;
    }

    public static boolean canUseAsFuel(ItemStack stack) {
        return AVAILABLE_FUELS.containsKey(stack.m_41720_()) || EndStoneSmelterBlockEntity.getFabricFuel(stack) > 2000;
    }

    public static void registerFuel(ItemLike fuel, int time) {
        AVAILABLE_FUELS.put(fuel.m_5456_(), time);
    }

    public static Map<Item, Integer> availableFuels() {
        return AVAILABLE_FUELS;
    }

    private static int getFabricFuel(ItemStack stack) {
        Integer ticks = (Integer)FuelRegistry.INSTANCE.get((ItemLike)stack.m_41720_());
        return ticks == null ? 0 : ticks;
    }

    static {
        AbstractFurnaceBlockEntity.m_58423_().forEach((item, time) -> {
            if (time >= 2000) {
                EndStoneSmelterBlockEntity.registerFuel((ItemLike)item, time);
            }
        });
    }
}

