/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlant;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.blocks.basis.EndPlantBlock;
import org.betterx.betterend.interfaces.survives.SurvivesOnEndBone;
import org.betterx.betterend.registry.EndFeatures;
import org.betterx.betterend.world.features.bushes.LargeAmaranitaFeature;
import org.betterx.betterend.world.features.trees.GiganticAmaranitaFeature;

public class SmallAmaranitaBlock
extends EndPlantBlock
implements SurvivesOnEndBone,
BehaviourPlant {
    private static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);

    public SmallAmaranitaBlock() {
        super(BehaviourBuilders.createPlant((MapColor)MapColor.f_283913_).m_222979_(BlockBehaviour.OffsetType.XZ));
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos bigPos = this.growBig(world, pos);
        if (bigPos != null) {
            if (((GiganticAmaranitaFeature)EndFeatures.GIGANTIC_AMARANITA.getFeature()).m_142674_((FeaturePlaceContext<NoneFeatureConfiguration>)new FeaturePlaceContext(Optional.empty(), (WorldGenLevel)world, null, random, bigPos, null))) {
                this.replaceMushroom(world, bigPos);
                this.replaceMushroom(world, bigPos.m_122019_());
                this.replaceMushroom(world, bigPos.m_122029_());
                this.replaceMushroom(world, bigPos.m_122019_().m_122029_());
            }
            return;
        }
        ((LargeAmaranitaFeature)EndFeatures.LARGE_AMARANITA.getFeature()).m_142674_((FeaturePlaceContext<NoneFeatureConfiguration>)new FeaturePlaceContext(Optional.empty(), (WorldGenLevel)world, null, random, pos, null));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        Vec3 vec3d = state.m_60824_(view, pos);
        return SHAPE.m_83216_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
    }

    private BlockPos growBig(ServerLevel world, BlockPos pos) {
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                BlockPos p = pos.m_7918_(x, 0, z);
                if (!this.checkFrame(world, p)) continue;
                return p;
            }
        }
        return null;
    }

    private boolean checkFrame(ServerLevel world, BlockPos pos) {
        return world.m_8055_(pos).m_60713_((Block)this) && world.m_8055_(pos.m_122019_()).m_60713_((Block)this) && world.m_8055_(pos.m_122029_()).m_60713_((Block)this) && world.m_8055_(pos.m_122019_().m_122029_()).m_60713_((Block)this);
    }

    private void replaceMushroom(ServerLevel world, BlockPos pos) {
        if (world.m_8055_(pos).m_60713_((Block)this)) {
            BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)pos, (Block)Blocks.f_50016_);
        }
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return random.m_188503_(8) == 0;
    }

    public boolean isTerrain(BlockState state) {
        return SurvivesOnEndBone.super.isTerrain(state);
    }
}

