/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.blocks.basis.PedestalBlock;
import org.betterx.betterend.blocks.entities.InfusionPedestalEntity;
import org.betterx.betterend.rituals.InfusionRitual;
import org.jetbrains.annotations.Nullable;

public class InfusionPedestal
extends PedestalBlock
implements BehaviourStone {
    private static final VoxelShape SHAPE_DEFAULT;
    private static final VoxelShape SHAPE_PEDESTAL_TOP;

    public InfusionPedestal() {
        super(Blocks.f_50080_);
        this.height = 1.08f;
    }

    @Override
    public void checkRitual(Level world, Player player, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof InfusionPedestalEntity) {
            InfusionPedestalEntity pedestal = (InfusionPedestalEntity)blockEntity;
            if (pedestal.hasRitual()) {
                InfusionRitual ritual = pedestal.getRitual();
                if (!ritual.isValid()) {
                    ritual.configure();
                }
                pedestal.getRitual().checkRecipe();
            } else {
                InfusionRitual ritual = pedestal.linkRitual(pedestal, world, pos);
                ritual.checkRecipe();
            }
        }
    }

    @Override
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new InfusionPedestalEntity(blockPos, blockState);
    }

    @Override
    public boolean hasUniqueEntity() {
        return true;
    }

    @Override
    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.m_60713_((Block)this)) {
            switch ((EndBlockProperties.PedestalState)((Object)state.m_61143_((Property)STATE))) {
                case PEDESTAL_TOP: {
                    return SHAPE_PEDESTAL_TOP;
                }
                case DEFAULT: {
                    return SHAPE_DEFAULT;
                }
            }
            return super.m_5940_(state, world, pos, context);
        }
        return super.m_5940_(state, world, pos, context);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return InfusionPedestalEntity::tickEntity;
    }

    static {
        VoxelShape basinUp = Block.m_49796_((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
        VoxelShape basinDown = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
        VoxelShape pedestalTop = Block.m_49796_((double)1.0, (double)9.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0);
        VoxelShape pedestalDefault = Block.m_49796_((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
        VoxelShape pillar = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0);
        VoxelShape pillarDefault = Block.m_49796_((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
        VoxelShape eyeDefault = Block.m_49796_((double)4.0, (double)15.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        VoxelShape eyeTop = Block.m_49796_((double)4.0, (double)11.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
        VoxelShape basin = Shapes.m_83110_((VoxelShape)basinDown, (VoxelShape)basinUp);
        SHAPE_DEFAULT = Shapes.m_83124_((VoxelShape)basin, (VoxelShape[])new VoxelShape[]{pillarDefault, pedestalDefault, eyeDefault});
        SHAPE_PEDESTAL_TOP = Shapes.m_83124_((VoxelShape)pillar, (VoxelShape[])new VoxelShape[]{pedestalTop, eyeTop});
    }
}

