/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;

public final class JarEntriesScanner {
    private JarEntriesScanner() {
    }

    public static void scanJar(Path jarPath, boolean scanNestedJars, EntriesConsumer consumer) {
        String topName = jarPath.getFileName().toString();
        try (JarFile jarFile = new JarFile(jarPath.toFile());){
            LinkedHashMap<String, Boolean> topEntries = new LinkedHashMap<String, Boolean>();
            ArrayList<NestedJar> nested = new ArrayList<NestedJar>();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                topEntries.put(name, entry.isDirectory());
                if (!scanNestedJars || entry.isDirectory() || !name.endsWith(".jar")) continue;
                try {
                    InputStream in = jarFile.getInputStream(entry);
                    try {
                        byte[] data = JarEntriesScanner.readAllBytes(in);
                        nested.add(new NestedJar(topName + "!/" + name, data));
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
            consumer.accept(topName, Collections.unmodifiableMap(topEntries));
            if (scanNestedJars) {
                for (NestedJar nj : nested) {
                    JarEntriesScanner.processNested(nj.containerName, nj.data, true, consumer);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void processNested(String containerName, byte[] data, boolean scanNestedJars, EntriesConsumer consumer) {
        try (JarInputStream jis = new JarInputStream(new ByteArrayInputStream(data));){
            JarEntry ne;
            LinkedHashMap<String, Boolean> entriesMap = new LinkedHashMap<String, Boolean>();
            ArrayList<NestedJar> nested = new ArrayList<NestedJar>();
            while ((ne = jis.getNextJarEntry()) != null) {
                String name = ne.getName();
                boolean isDir = ne.isDirectory();
                entriesMap.put(name, isDir);
                if (!scanNestedJars || isDir || !name.endsWith(".jar")) continue;
                try {
                    byte[] nestedData = JarEntriesScanner.readAllBytes(jis);
                    nested.add(new NestedJar(containerName + "!/" + name, nestedData));
                }
                catch (IOException iOException) {}
            }
            consumer.accept(containerName, Collections.unmodifiableMap(entriesMap));
            if (scanNestedJars) {
                for (NestedJar nj : nested) {
                    JarEntriesScanner.processNested(nj.containerName, nj.data, true, consumer);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static byte[] readAllBytes(InputStream in) throws IOException {
        int r;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        byte[] tmp = new byte[8192];
        while ((r = in.read(tmp)) != -1) {
            buf.write(tmp, 0, r);
        }
        return buf.toByteArray();
    }

    private static class NestedJar {
        final String containerName;
        final byte[] data;

        NestedJar(String containerName, byte[] data) {
            this.containerName = containerName;
            this.data = data;
        }
    }

    @FunctionalInterface
    public static interface EntriesConsumer
    extends BiConsumer<String, Map<String, Boolean>> {
    }
}

