/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.utils;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.class_loading.Boot;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Predicate;

public class CrashReportsHelper {
    public static HashSet<Path> getRelevantFiles(Path dir, Predicate<String> filenameFilter) {
        HashSet<Path> relevantFiles = new HashSet<Path>();
        if (!Files.exists(dir, new LinkOption[0])) {
            return relevantFiles;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path entry : stream) {
                if (!Files.isRegularFile(entry, new LinkOption[0]) || entry.getFileName() == null || !filenameFilter.test(entry.getFileName().toString()) || entry.toFile().lastModified() < Boot.parentStarted) continue;
                relevantFiles.add(entry);
            }
        }
        catch (IOException e) {
            CrashAssistantApp.LOGGER.error("Error while scanning files in " + String.valueOf(dir) + ": ", (Throwable)e);
            return new HashSet<Path>();
        }
        return relevantFiles;
    }
}

