/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.gui.analysis.dependencies.AzureLibDependenciesAnalysisGUI;
import dev.kostromdan.mods.crash_assistant.app.gui.analysis.dependencies.JdepsDependenciesAnalysisGUI;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReason;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogType;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import java.util.HashSet;
import java.util.Objects;
import javax.swing.JFrame;

public class AzureLibAddons
extends KnownCrashReason {
    public AzureLibAddons() {
        super(new HashSet<LogType>(){
            {
                this.add(LogType.LOG);
                this.add(LogType.CRASH_REPORT);
                this.add(LogType.LAUNCHER_LOG);
            }
        }, LanguageProvider.get((String)"warnings.azure_lib_addons"), "(?i)java\\.lang\\.(ClassNotFoundException|NoClassDefFoundError): mod[./]azure[./]azurelib");
        this.autoFixButtons.put(LanguageProvider.get((String)"gui.analysis.find_incompatible_azure_lib_addons"), dialog -> AzureLibDependenciesAnalysisGUI.showAzureLibAnalysisDialog((JFrame)dialog.getOwner()));
        this.autoFixButtons.put(LanguageProvider.get((String)"gui.analysis.azure_lib.find_mods"), dialog -> new JdepsDependenciesAnalysisGUI((JFrame)dialog.getOwner(), "mod.azure.azurelib").start());
    }

    @Override
    public boolean matches(Log log) {
        if (CrashAssistantApp.gameLaunchedSuccessfully) {
            return false;
        }
        if (ModListUtils.getCurrentModList((boolean)true).stream().noneMatch(mod -> Objects.equals(mod.getModId(), "azurelib"))) {
            return false;
        }
        return super.matches(log);
    }
}

