/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui.modlist;

import dev.kostromdan.mods.crash_assistant.app.gui.ControlPanel;
import dev.kostromdan.mods.crash_assistant.app.gui.modlist.DiffEntry;
import dev.kostromdan.mods.crash_assistant.app.gui.modlist.ModListDiffDialog;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class SectionPanel {
    private final ModListDiffDialog dialog;
    private final ModListDiffDialog.SectionType type;
    private final List<DiffEntry> entries;
    private final JPanel container;
    private final JTable table;
    private final JCheckBox master = new JCheckBox();
    private final JLabel headerLabel = new JLabel();
    private boolean collapsed = false;
    private final Model model;
    private final String fileColumnLabel;
    private final Map<Integer, ModListDiffDialog.SectionAction> actionColumns = new HashMap<Integer, ModListDiffDialog.SectionAction>();
    private JComponent body;
    private JPanel headerPanel;

    SectionPanel(final ModListDiffDialog dialog, ModListDiffDialog.SectionType type, final List<DiffEntry> entries) {
        this.dialog = dialog;
        this.type = type;
        this.entries = entries;
        this.fileColumnLabel = type == ModListDiffDialog.SectionType.UPDATED ? LanguageProvider.get((String)"gui.modlist_diff.column.file_current") : LanguageProvider.get((String)"gui.modlist_diff.column.file");
        this.model = new Model();
        this.container = new JPanel(new BorderLayout()){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = new Dimension();
                if (SectionPanel.this.headerPanel != null) {
                    Dimension h = SectionPanel.this.headerPanel.getPreferredSize();
                    d.width = Math.max(d.width, h.width);
                    d.height += h.height;
                }
                if (SectionPanel.this.body != null && SectionPanel.this.body.isVisible()) {
                    Dimension b = SectionPanel.this.body.getPreferredSize();
                    d.width = Math.max(d.width, b.width);
                    d.height += b.height;
                }
                Insets in = this.getInsets();
                d.width += in.left + in.right;
                d.height += in.top + in.bottom;
                return d;
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                Dimension d = this.getPreferredSize();
                return new Dimension(d.width, d.height);
            }
        };
        this.table = new JTable(this.model){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                ModListDiffDialog.SectionAction action;
                boolean active;
                Component c = super.prepareRenderer(renderer, row, column);
                DiffEntry entry = (DiffEntry)entries.get(this.convertRowIndexToModel(row));
                int modelCol = this.convertColumnIndexToModel(column);
                boolean enabled = active = dialog.isEntryActive(entry);
                if (c instanceof JButton && (action = SectionPanel.this.actionColumns.get(modelCol)) != null) {
                    enabled = dialog.isActionEnabled(entry, action);
                }
                c.setEnabled(enabled);
                if (c instanceof JComponent) {
                    Color base = this.isRowSelected(row) ? this.getSelectionBackground() : this.getBackground();
                    ((JComponent)c).setOpaque(true);
                    ((JComponent)c).setBackground(!active || entry.resolved ? new Color(235, 235, 235) : base);
                }
                c.setForeground(!active || entry.resolved ? Color.GRAY : this.getForeground());
                return c;
            }

            @Override
            public String getToolTipText(MouseEvent event) {
                int rowIndex = this.rowAtPoint(event.getPoint());
                int colIndex = this.columnAtPoint(event.getPoint());
                if (rowIndex >= 0 && colIndex == 1) {
                    DiffEntry entry = (DiffEntry)entries.get(this.convertRowIndexToModel(rowIndex));
                    return entry.tooltip;
                }
                return super.getToolTipText(event);
            }
        };
        this.table.putClientProperty("sectionPanel", this);
        this.table.setRowHeight(28);
        this.table.setFillsViewportHeight(true);
        this.table.setAutoResizeMode(0);
        this.table.setDefaultEditor(Boolean.class, new DefaultCellEditor(new JCheckBox()));
        this.table.setDefaultRenderer(Boolean.class, this.table.getDefaultRenderer(Boolean.class));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ControlPanel.stopMovingToTop = true;
            }
        });
        this.table.getTableHeader().setReorderingAllowed(false);
        this.configureColumns();
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SectionPanel.this.updateHeader();
                dialog.updateStatusLabel();
                SectionPanel.this.container.revalidate();
                SectionPanel.this.updateRowHeights();
            }
        });
        JPanel header = new JPanel(new FlowLayout(0, 6, 4));
        header.setBorder(new EmptyBorder(4, 6, 4, 6));
        this.master.addActionListener(e -> this.toggleAll());
        JButton toggle = new JButton("\u25bc");
        toggle.addActionListener(e -> this.toggle());
        header.add(this.master);
        header.add(toggle);
        header.add(this.headerLabel);
        this.headerPanel = header;
        this.container.add((Component)header, "North");
        if (entries.isEmpty()) {
            JLabel empty = new JLabel(this.getEmptyText(type));
            empty.setBorder(new EmptyBorder(8, 12, 8, 12));
            this.body = empty;
            this.master.setEnabled(false);
        } else {
            JPanel tableContainer = new JPanel(new BorderLayout());
            tableContainer.add((Component)this.table.getTableHeader(), "North");
            tableContainer.add((Component)this.table, "Center");
            this.body = tableContainer;
        }
        this.container.add((Component)this.body, "Center");
        this.updateHeader();
    }

    JComponent getComponent() {
        return this.container;
    }

    void refresh() {
        this.model.fireTableDataChanged();
        this.updateHeader();
        this.updateRowHeights();
    }

    void toggle() {
        this.collapsed = !this.collapsed;
        this.body.setVisible(!this.collapsed);
        Component header = this.container.getComponent(0);
        if (header instanceof JPanel) {
            Component[] comps;
            for (Component c : comps = ((JPanel)header).getComponents()) {
                if (!(c instanceof JButton)) continue;
                ((JButton)c).setText(this.collapsed ? "\u25ba" : "\u25bc");
                break;
            }
        }
        this.container.revalidate();
        this.container.repaint();
    }

    private String getEmptyText(ModListDiffDialog.SectionType type) {
        switch (type) {
            case ADDED: {
                return LanguageProvider.get((String)"gui.modlist_diff.section.empty.added");
            }
            case UPDATED: {
                return LanguageProvider.get((String)"gui.modlist_diff.section.empty.updated");
            }
        }
        return LanguageProvider.get((String)"gui.modlist_diff.section.empty.removed");
    }

    private void toggleAll() {
        boolean target = this.master.isSelected();
        for (DiffEntry entry : this.entries) {
            if (entry.resolved) continue;
            entry.selected = target;
        }
        this.model.fireTableDataChanged();
    }

    private void configureColumns() {
        int startActionCol;
        TableColumnModel cm = this.table.getColumnModel();
        TableColumn fileCol = cm.getColumn(1);
        fileCol.setCellRenderer(new FileNameRenderer());
        int dynamicNameWidth = Math.max(this.measureWidestEntry(), this.dialog.measureHeaderWidth(this.fileColumnLabel));
        if (this.table.getPreferredScrollableViewportSize().width > 0) {
            dynamicNameWidth = Math.max(dynamicNameWidth, this.table.getPreferredScrollableViewportSize().width / 2);
        }
        cm.getColumn(0).setPreferredWidth(40);
        cm.getColumn(0).setMaxWidth(40);
        cm.getColumn(1).setPreferredWidth(dynamicNameWidth);
        if (this.type == ModListDiffDialog.SectionType.UPDATED) {
            cm.getColumn(2).setPreferredWidth(Math.max(this.measureUpdatedFromWidth(), 120));
            cm.getColumn(3).setPreferredWidth(64);
            cm.getColumn(3).setMaxWidth(64);
            cm.getColumn(4).setPreferredWidth(64);
            cm.getColumn(4).setMaxWidth(64);
        } else {
            cm.getColumn(2).setPreferredWidth(64);
            cm.getColumn(2).setMaxWidth(64);
            cm.getColumn(3).setPreferredWidth(64);
            cm.getColumn(3).setMaxWidth(64);
        }
        cm.getColumn(0).setCellRenderer(new BooleanRenderer());
        cm.getColumn(0).setCellEditor(new DefaultCellEditor(new JCheckBox()));
        IconButtonRenderer cfRenderer = new IconButtonRenderer(this.dialog.getCfIcon(), false);
        IconButtonRenderer mrRenderer = new IconButtonRenderer(this.dialog.getMrIcon(), true);
        if (this.type == ModListDiffDialog.SectionType.UPDATED) {
            cm.getColumn(3).setCellRenderer(cfRenderer);
            cm.getColumn(4).setCellRenderer(mrRenderer);
            cm.getColumn(3).setCellEditor(new IconButtonEditor(this, false));
            cm.getColumn(4).setCellEditor(new IconButtonEditor(this, true));
        } else {
            cm.getColumn(2).setCellRenderer(cfRenderer);
            cm.getColumn(3).setCellRenderer(mrRenderer);
            cm.getColumn(2).setCellEditor(new IconButtonEditor(this, false));
            cm.getColumn(3).setCellEditor(new IconButtonEditor(this, true));
        }
        int colIdx = startActionCol = this.type == ModListDiffDialog.SectionType.UPDATED ? 5 : 4;
        switch (this.type) {
            case ADDED: {
                this.actionColumns.put(colIdx, ModListDiffDialog.SectionAction.DISABLE);
                this.actionColumns.put(++colIdx, ModListDiffDialog.SectionAction.REMOVE);
                this.actionColumns.put(++colIdx, ModListDiffDialog.SectionAction.SHOW_FOLDER);
                break;
            }
            case UPDATED: {
                cm.getColumn(colIdx).setPreferredWidth(140);
                this.actionColumns.put(colIdx, ModListDiffDialog.SectionAction.REVERT);
                this.actionColumns.put(colIdx + 1, ModListDiffDialog.SectionAction.DISABLE);
                this.actionColumns.put(colIdx + 2, ModListDiffDialog.SectionAction.REMOVE);
                this.actionColumns.put(colIdx + 3, ModListDiffDialog.SectionAction.SHOW_FOLDER);
                break;
            }
            case REMOVED: {
                this.actionColumns.put(colIdx, ModListDiffDialog.SectionAction.RESTORE);
            }
        }
        for (int i = startActionCol; i < this.model.getColumnCount(); ++i) {
            ModListDiffDialog.SectionAction action = this.actionColumns.get(i);
            if (action == null) continue;
            int w = this.measureActionColumnWidth(action, this.model.getColumnName(i));
            cm.getColumn(i).setPreferredWidth(w);
            cm.getColumn(i).setMaxWidth(w);
            cm.getColumn(i).setMinWidth(w);
            cm.getColumn(i).setCellRenderer(new ActionButtonRenderer());
            cm.getColumn(i).setCellEditor(new ActionButtonEditor(this, action));
        }
        this.updateRowHeights();
    }

    private int measureWidestEntry() {
        int max = 0;
        FontMetrics fm = this.table.getFontMetrics(this.table.getFont());
        for (DiffEntry entry : this.entries) {
            max = Math.max(max, this.measureLines(fm, entry.primaryDisplayLines()));
        }
        return max + 32;
    }

    private int measureUpdatedFromWidth() {
        if (this.type != ModListDiffDialog.SectionType.UPDATED) {
            return 0;
        }
        int max = 0;
        FontMetrics fm = this.table.getFontMetrics(this.table.getFont());
        for (DiffEntry entry : this.entries) {
            max = Math.max(max, this.measureLines(fm, entry.savedDisplayLines()));
        }
        return max + 24;
    }

    private int measureActionColumnWidth(ModListDiffDialog.SectionAction action, String header) {
        ArrayList<String> texts = new ArrayList<String>();
        texts.add(header);
        switch (action) {
            case DISABLE: {
                texts.add(this.dialog.getRowEnableLabel());
                break;
            }
            case REMOVE: {
                texts.add(LanguageProvider.get((String)"gui.modlist_diff.section.removed"));
                break;
            }
            case REVERT: {
                texts.add(LanguageProvider.get((String)"gui.modlist_diff.actions.reverting"));
                texts.add(LanguageProvider.get((String)"gui.modlist_diff.actions.reverted"));
                break;
            }
            case RESTORE: {
                texts.add(LanguageProvider.get((String)"gui.modlist_diff.actions.restoring"));
                texts.add(LanguageProvider.get((String)"gui.modlist_diff.actions.restored"));
                break;
            }
            case SHOW_FOLDER: {
                texts.add(LanguageProvider.get((String)"gui.show"));
            }
        }
        int max = 0;
        JButton dummy = new JButton();
        dummy.setMargin(new Insets(2, 6, 2, 6));
        for (String s : texts) {
            if (s == null) continue;
            dummy.setText(s);
            max = Math.max(max, dummy.getPreferredSize().width);
        }
        return max + 10;
    }

    private int measureLines(FontMetrics fm, List<String> lines) {
        int max = 0;
        for (String line : lines) {
            if (line == null) continue;
            max = Math.max(max, fm.stringWidth(line));
        }
        return max;
    }

    private void updateRowHeights() {
        int baseHeight = 28;
        for (int row = 0; row < this.table.getRowCount(); ++row) {
            int modelRow = this.table.convertRowIndexToModel(row);
            if (modelRow < 0 || modelRow >= this.entries.size()) continue;
            DiffEntry entry = this.entries.get(modelRow);
            int lines = Math.max(1, entry.maxDisplayLines());
            this.table.setRowHeight(row, Math.max(baseHeight, baseHeight * lines));
        }
    }

    void updateHeader() {
        int selected = 0;
        int total = 0;
        for (DiffEntry e : this.entries) {
            if (e.resolved) continue;
            ++total;
            if (!e.selected) continue;
            ++selected;
        }
        this.master.setSelected(selected == total && total > 0);
        this.headerLabel.setText((switch (this.type) {
            case ModListDiffDialog.SectionType.ADDED -> LanguageProvider.get((String)"gui.modlist_diff.section.added");
            case ModListDiffDialog.SectionType.UPDATED -> LanguageProvider.get((String)"gui.modlist_diff.section.updated");
            default -> LanguageProvider.get((String)"gui.modlist_diff.section.removed");
        }) + " (" + total + ")");
    }

    private class Model
    extends AbstractTableModel {
        private final String[] columns;

        Model() {
            boolean updated;
            ArrayList<String> cols = new ArrayList<String>();
            cols.add("");
            cols.add(SectionPanel.this.fileColumnLabel);
            boolean bl = updated = SectionPanel.this.type == ModListDiffDialog.SectionType.UPDATED;
            if (updated) {
                cols.add(LanguageProvider.get((String)"gui.modlist_diff.updated_from"));
            }
            cols.add("CF");
            cols.add("MR");
            switch (SectionPanel.this.type) {
                case ADDED: {
                    cols.add(LanguageProvider.get((String)"gui.files_remover.disable"));
                    cols.add(LanguageProvider.get((String)"gui.files_remover.remove"));
                    cols.add(LanguageProvider.get((String)"gui.show_in_explorer_button"));
                    break;
                }
                case UPDATED: {
                    cols.add(LanguageProvider.get((String)"gui.modlist_diff.actions.revert"));
                    cols.add(LanguageProvider.get((String)"gui.files_remover.disable"));
                    cols.add(LanguageProvider.get((String)"gui.files_remover.remove"));
                    cols.add(LanguageProvider.get((String)"gui.show_in_explorer_button"));
                    break;
                }
                case REMOVED: {
                    cols.add(LanguageProvider.get((String)"gui.modlist_diff.actions.restore"));
                }
            }
            this.columns = cols.toArray(new String[0]);
        }

        @Override
        public int getRowCount() {
            return SectionPanel.this.entries.size();
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columns[column];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? Boolean.class : Object.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            int mrCol;
            DiffEntry entry = SectionPanel.this.entries.get(rowIndex);
            if (!SectionPanel.this.dialog.isEntryActive(entry)) {
                return false;
            }
            if (columnIndex == 0) {
                return true;
            }
            boolean updated = SectionPanel.this.type == ModListDiffDialog.SectionType.UPDATED;
            int cfCol = updated ? 3 : 2;
            int n = mrCol = updated ? 4 : 3;
            if (updated && columnIndex == 2) {
                return false;
            }
            if (columnIndex == cfCol) {
                return entry.hasAnyCurseMatch();
            }
            if (columnIndex == mrCol) {
                return entry.hasAnyModrinthMatch();
            }
            ModListDiffDialog.SectionAction action = SectionPanel.this.actionColumns.get(columnIndex);
            if (action != null) {
                return SectionPanel.this.dialog.isActionEnabled(entry, action);
            }
            return true;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DiffEntry entry = SectionPanel.this.entries.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return entry.selected && !entry.resolved;
                }
                case 1: {
                    return entry.primaryDisplayText();
                }
                case 2: {
                    if (SectionPanel.this.type == ModListDiffDialog.SectionType.UPDATED) {
                        return entry.savedDisplayText();
                    }
                    return "";
                }
                case 3: {
                    return "";
                }
            }
            ModListDiffDialog.SectionAction action = SectionPanel.this.actionColumns.get(columnIndex);
            if (action != null) {
                return SectionPanel.this.dialog.getActionLabel(entry, action, this.columns[columnIndex]);
            }
            return this.columns[columnIndex];
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                SectionPanel.this.entries.get((int)rowIndex).selected = (Boolean)aValue;
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            }
        }
    }

    private static class FileNameRenderer
    extends DefaultTableCellRenderer {
        private final Color disabledColor = new Color(255, 0, 0);

        private FileNameRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            SectionPanel panel = (SectionPanel)table.getClientProperty("sectionPanel");
            if (panel != null) {
                DiffEntry entry = panel.entries.get(table.convertRowIndexToModel(row));
                boolean disabled = entry.areAllCurrentDisabled();
                if (disabled && value instanceof String) {
                    this.setText(this.wrapRed((String)value));
                } else {
                    this.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                }
            }
            return c;
        }

        private String wrapRed(String text) {
            if (text == null) {
                return "";
            }
            if (text.startsWith("<html>")) {
                return text.replaceFirst("<html>", "<html><span style='color:#ff0000;'>").replaceFirst("</html>$", "</span></html>");
            }
            return "<html><span style='color:#ff0000;'>" + text + "</span></html>";
        }
    }

    private static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        BooleanRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setSelected(value instanceof Boolean && (Boolean)value != false);
            this.setEnabled(table.isEnabled());
            this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            return this;
        }
    }

    private class IconButtonRenderer
    extends JButton
    implements TableCellRenderer {
        private final ImageIcon icon;
        private final boolean modrinth;

        IconButtonRenderer(ImageIcon icon, boolean modrinth) {
            this.icon = icon;
            this.modrinth = modrinth;
            this.setOpaque(true);
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            SectionPanel panel = (SectionPanel)table.getClientProperty("sectionPanel");
            this.setIcon(null);
            if (panel != null && table.getRowCount() > 0) {
                boolean lookupReady;
                DiffEntry entry = panel.entries.get(table.convertRowIndexToModel(row));
                boolean hasPlatform = this.modrinth ? entry.hasAnyModrinthMatch() : entry.hasAnyCurseMatch();
                boolean bl = lookupReady = this.modrinth ? SectionPanel.this.dialog.isMrReady() : SectionPanel.this.dialog.isCfReady();
                if (!lookupReady) {
                    this.setEnabled(false);
                    this.setToolTipText(LanguageProvider.get((String)"gui.modlist_diff.fetching_warning"));
                } else {
                    this.setToolTipText(null);
                    this.setEnabled(hasPlatform && this.icon != null && SectionPanel.this.dialog.isEntryActive(entry));
                }
                if (hasPlatform) {
                    this.setIcon(this.icon);
                }
            } else {
                this.setEnabled(false);
            }
            return this;
        }
    }

    private class IconButtonEditor
    extends BaseButtonEditor {
        private final boolean modrinth;

        IconButtonEditor(SectionPanel panel, boolean modrinth) {
            super(panel);
            this.modrinth = modrinth;
            this.button.setBorderPainted(false);
            this.button.setContentAreaFilled(false);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            this.button.setIcon(this.modrinth ? SectionPanel.this.dialog.getMrIcon() : SectionPanel.this.dialog.getCfIcon());
            return c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DiffEntry entry = this.panel.entries.get(this.row);
            if (this.modrinth) {
                SectionPanel.this.dialog.openModrinthProject(entry);
            } else {
                SectionPanel.this.dialog.openCurseForgeProject(entry);
            }
            this.fireEditingStopped();
        }
    }

    private class ActionButtonRenderer
    extends JButton
    implements TableCellRenderer {
        ActionButtonRenderer() {
            this.setOpaque(true);
            this.setMargin(new Insets(2, 6, 2, 6));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value == null ? "" : String.valueOf(value));
            SectionPanel panel = (SectionPanel)table.getClientProperty("sectionPanel");
            if (panel != null && table.getRowCount() > 0) {
                DiffEntry entry = panel.entries.get(table.convertRowIndexToModel(row));
                ModListDiffDialog.SectionAction action = panel.actionColumns.get(column);
                this.setEnabled(SectionPanel.this.dialog.isActionEnabled(entry, action));
            } else {
                this.setEnabled(false);
            }
            return this;
        }
    }

    private class ActionButtonEditor
    extends BaseButtonEditor {
        private final ModListDiffDialog.SectionAction action;

        ActionButtonEditor(SectionPanel panel, ModListDiffDialog.SectionAction action) {
            super(panel);
            this.action = action;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            DiffEntry entry = this.panel.entries.get(this.row);
            this.button.setEnabled(SectionPanel.this.dialog.isActionEnabled(entry, this.action));
            return c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DiffEntry entry = this.panel.entries.get(this.row);
            ModListDiffDialog.SectionAction effective = this.action;
            if (this.action == ModListDiffDialog.SectionAction.DISABLE && SectionPanel.this.dialog.isDisabledEntry(entry)) {
                effective = ModListDiffDialog.SectionAction.ENABLE;
            }
            if (!SectionPanel.this.dialog.isActionEnabled(entry, effective)) {
                this.fireEditingCanceled();
                return;
            }
            SectionPanel.this.dialog.runActionAsync(entry, effective);
            this.fireEditingStopped();
        }
    }

    private abstract class BaseButtonEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        protected final JButton button = new JButton();
        protected final SectionPanel panel;
        protected int row;

        BaseButtonEditor(SectionPanel panel) {
            this.panel = panel;
            this.button.addActionListener(this);
            this.button.setMargin(new Insets(2, 6, 2, 6));
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.row = table.convertRowIndexToModel(row);
            this.button.setText(value == null ? "" : String.valueOf(value));
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            return this.button.getText();
        }
    }
}

