/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui.analysis.gml;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;

public class GMLMappingDownloaderImpl {
    private final Consumer<String> logger;
    private final Gson gson;
    private static final String PISTON_META_URL = "https://piston-meta.mojang.com/mc/game/version_manifest_v2.json";

    public GMLMappingDownloaderImpl(Consumer<String> logger) {
        this.logger = logger;
        this.gson = new Gson();
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: java GMLMappingDownloaderImpl <minecraft_version> <mcp_version>");
            System.exit(1);
        }
        String mcVersion = args[0];
        String mcpVersion = args[1];
        GMLMappingDownloaderImpl downloader = new GMLMappingDownloaderImpl(System.out::println);
        try {
            downloader.download(mcVersion, mcpVersion);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void download(String mcVersion, String mcpVersion) throws IOException, NoSuchAlgorithmException {
        List<String> oldVersions = Arrays.asList("1.19.2", "1.19.3", "1.19.4");
        Path cacheDir = oldVersions.contains(mcVersion) ? Paths.get("mod_data", "gml") : Paths.get("mod_data", "gml", mcVersion);
        Files.createDirectories(cacheDir, new FileAttribute[0]);
        this.logger.accept("Cache directory created at: " + String.valueOf(cacheDir));
        this.logger.accept("Downloading version manifest...");
        PistonMeta pistonMeta = this.getJson(PISTON_META_URL, PistonMeta.class);
        PistonMeta.VersionInfo versionInfo = pistonMeta.versions.stream().filter(v -> mcVersion.equals(v.id)).findFirst().orElseThrow(() -> new IOException("Could not find Minecraft version " + mcVersion + " in version manifest."));
        this.logger.accept("Found version metadata URL: " + versionInfo.url);
        Path versionJsonPath = cacheDir.resolve("version.json");
        this.downloadAndVerify(versionInfo.url, versionJsonPath, versionInfo.sha1, "version.json");
        VersionMeta versionMeta = (VersionMeta)this.gson.fromJson(new String(Files.readAllBytes(versionJsonPath), StandardCharsets.UTF_8), VersionMeta.class);
        VersionMeta.Download clientMappings = versionMeta.downloads.get("client_mappings");
        if (clientMappings == null) {
            throw new IOException("Could not find client_mappings in version.json");
        }
        Path officialMappingsPath = cacheDir.resolve("official.txt");
        this.downloadAndVerify(clientMappings.url, officialMappingsPath, clientMappings.sha1, "official.txt");
        String mcpConfigUrl = String.format("https://maven.minecraftforge.net/de/oceanlabs/mcp/mcp_config/%s-%s/mcp_config-%s-%s.zip", mcVersion, mcpVersion, mcVersion, mcpVersion);
        Path mcpZipPath = cacheDir.resolve("srg.zip");
        this.logger.accept("Downloading MCPConfig from: " + mcpConfigUrl);
        this.downloadFile(mcpConfigUrl, mcpZipPath, "MCPConfig zip");
        this.logger.accept("MCPConfig zip saved to: " + String.valueOf(mcpZipPath));
        this.logger.accept("All necessary mapping files have been downloaded successfully.");
    }

    private <T> T getJson(String urlString, Class<T> classOfT) throws IOException {
        HttpURLConnection connection = null;
        try {
            Object object;
            URL url = new URL(urlString);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new IOException("Failed to download JSON from " + urlString + ". Status code: " + responseCode);
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                object = this.gson.fromJson((Reader)reader, classOfT);
            }
            return (T)object;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private void downloadAndVerify(String url, Path destination, String expectedSha1, String fileDescription) throws IOException, NoSuchAlgorithmException {
        String actualSha1;
        if (Files.exists(destination, new LinkOption[0])) {
            actualSha1 = this.calculateSha1(destination);
            if (expectedSha1.equalsIgnoreCase(actualSha1)) {
                this.logger.accept(fileDescription + " is up to date. Skipping download.");
                return;
            }
            this.logger.accept("Checksum mismatch for " + fileDescription + ". Re-downloading...");
        }
        this.downloadFile(url, destination, fileDescription);
        actualSha1 = this.calculateSha1(destination);
        if (!expectedSha1.equalsIgnoreCase(actualSha1)) {
            throw new IOException("SHA1 checksum verification failed for " + fileDescription + " downloaded from " + url);
        }
        this.logger.accept("Verified " + fileDescription + " successfully.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(String urlString, Path destination, String fileDescription) throws IOException {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(urlString);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("Accept-Encoding", "gzip");
            connection.setInstanceFollowRedirects(true);
            int responseCode = connection.getResponseCode();
            if (responseCode < 200 || responseCode >= 300) {
                throw new IOException("Failed to download " + fileDescription + " from " + urlString + ". Status code: " + responseCode);
            }
            try (InputStream bodyStream = connection.getInputStream();){
                String contentEncoding = connection.getContentEncoding();
                InputStream streamToRead = "gzip".equalsIgnoreCase(contentEncoding) ? new GZIPInputStream(bodyStream) : bodyStream;
                Files.copy(streamToRead, destination, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private String calculateSha1(Path path) throws IOException, NoSuchAlgorithmException {
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = is.read(buffer)) > 0) {
                sha1.update(buffer, 0, read);
            }
        }
        byte[] hash = sha1.digest();
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private static class PistonMeta {
        List<VersionInfo> versions;

        private PistonMeta() {
        }

        private static class VersionInfo {
            String id;
            String url;
            String sha1;

            private VersionInfo() {
            }
        }
    }

    private static class VersionMeta {
        Map<String, Download> downloads;

        private VersionMeta() {
        }

        private static class Download {
            String sha1;
            String url;

            private Download() {
            }
        }
    }
}

