/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui.analysis.dependencies;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.gui.analysis.dependencies.DependenciesAnalysisGUIBase;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantLocalConfig;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class JdepsDependenciesAnalysisGUI
extends DependenciesAnalysisGUIBase {
    private final String searchOriginal;
    private final String targetClassPath;

    @Override
    protected void recreateSelf() {
        new JdepsDependenciesAnalysisGUI((JFrame)this.dialog.getParent(), this.searchOriginal).start();
    }

    public JdepsDependenciesAnalysisGUI(JFrame parent, String className) {
        super(parent, LanguageProvider.get((String)"gui.menu.analysis.jdeps_dependencies_analysis"), LanguageProvider.get((String)"gui.analysis.jdeps.header"));
        String term = this.searchOriginal = className.trim();
        if (term.toLowerCase().endsWith(".class")) {
            term = term.substring(0, term.length() - 6);
        }
        term = term.replace('.', '/');
        this.targetClassPath = term.toLowerCase() + ".class";
    }

    public static void showDialog(JFrame parent) {
        String lastSearch = (String)CrashAssistantLocalConfig.get((String)"analysis.jdeps.last_search");
        String input = (String)JOptionPane.showInputDialog(parent, LanguageProvider.get((String)"gui.analysis.jdeps.header") + "\n\n" + LanguageProvider.get((String)"gui.analysis.jdeps.input_message"), LanguageProvider.get((String)"gui.menu.analysis.jdeps_dependencies_analysis"), -1, null, null, lastSearch);
        if (input != null && !input.trim().isEmpty()) {
            CrashAssistantLocalConfig.set((String)"analysis.jdeps.last_search", (Object)input.trim());
            new JdepsDependenciesAnalysisGUI(parent, input.trim()).start();
        }
    }

    @Override
    protected Predicate<String> isRelevantClass() {
        return name -> false;
    }

    @Override
    protected String getModId() {
        return "";
    }

    @Override
    protected String getModName() {
        return "";
    }

    private Predicate<String> buildPredicate() {
        String targetLower = this.targetClassPath;
        String targetLowerNoExt = targetLower.endsWith(".class") ? targetLower.substring(0, targetLower.length() - 6) : targetLower;
        CrashAssistantApp.LOGGER.info("Target class path: {}", (Object)targetLowerNoExt);
        int slashIdx = targetLower.lastIndexOf(47);
        String simpleWithExt = slashIdx >= 0 ? targetLower.substring(slashIdx + 1) : targetLower;
        String simple = simpleWithExt.endsWith(".class") ? simpleWithExt.substring(0, simpleWithExt.length() - 6) : simpleWithExt;
        String simpleLower = simple.toLowerCase();
        boolean userSpecifiedPackageOrFqn = this.searchOriginal.contains(".") || this.searchOriginal.contains("/");
        return classPath -> {
            String innerSimple;
            Object n = classPath.toLowerCase();
            if (!((String)n).endsWith(".class")) {
                n = (String)n + ".class";
            }
            if (((String)n).equals(targetLower)) {
                return true;
            }
            if (userSpecifiedPackageOrFqn) {
                return ((String)n).startsWith(targetLowerNoExt);
            }
            int lastSlash = ((String)n).lastIndexOf(47);
            String baseNoExt = ((String)n).substring(lastSlash + 1, ((String)n).length() - 6);
            if (baseNoExt.equals(simpleLower)) {
                return true;
            }
            int lastDollarInBase = baseNoExt.lastIndexOf(36);
            String string = innerSimple = lastDollarInBase >= 0 ? baseNoExt.substring(lastDollarInBase + 1) : baseNoExt;
            return innerSimple.equals(simpleLower);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performAnalysis() {
        String jdepsPath = this.getJDepsPath();
        if (jdepsPath == null) {
            SwingUtilities.invokeLater(() -> {
                this.showJdepsWarn((JFrame)this.dialog.getParent(), this.dialog);
                this.dialog.dispose();
            });
            return;
        }
        CrashAssistantApp.LOGGER.info("Using jdeps at: \"{}\"", (Object)jdepsPath);
        LinkedHashSet modsToAnalyze = ModListUtils.getCurrentModList((boolean)true);
        int totalMods = modsToAnalyze.size();
        AtomicInteger completed = new AtomicInteger(0);
        AtomicInteger foundAny = new AtomicInteger(0);
        List matchedMods = Collections.synchronizedList(new ArrayList());
        Predicate<String> predicate = this.buildPredicate();
        SwingUtilities.invokeLater(() -> this.progressBar.setMaximum(totalMods));
        for (Object mod : modsToAnalyze) {
            executor.submit(() -> this.lambda$performAnalysis$7((Mod)mod, jdepsPath, predicate, foundAny, matchedMods, completed));
        }
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!isCancelled) {
            if (foundAny.get() == 0) {
                SwingUtilities.invokeLater(() -> {
                    String msg = LanguageProvider.get((String)"gui.analysis.jdeps.not_found").replace("$TERM$", this.searchOriginal);
                    this.appendStyledText(msg, NORMAL_COLOR);
                });
                CrashAssistantApp.LOGGER.info("Haven't found in any mod dependencies on '{}'.", (Object)this.searchOriginal);
            } else {
                ArrayList copy;
                Object mod;
                mod = matchedMods;
                synchronized (mod) {
                    copy = new ArrayList(matchedMods);
                }
                copy.sort(String::compareTo);
                StringBuilder sb = new StringBuilder();
                sb.append("Mods depending on '").append(this.searchOriginal).append("':\n");
                for (String jar : copy) {
                    sb.append(jar).append('\n');
                }
                CrashAssistantApp.LOGGER.info(sb.toString().trim());
            }
        }
        if (this.isIncludeNestedEnabled()) {
            try {
                this.cleanJdepsTmp();
            }
            catch (Exception e) {
                CrashAssistantApp.LOGGER.warn("Failed to clean jdeps tmp directory after analysis: {}", (Object)e.getMessage());
            }
        }
    }

    private /* synthetic */ void lambda$performAnalysis$7(Mod mod, String jdepsPath, Predicate predicate, AtomicInteger foundAny, List matchedMods, AtomicInteger completed) {
        if (isCancelled) {
            return;
        }
        SwingUtilities.invokeLater(() -> this.currentJarLabel.setText(LanguageProvider.get((String)"gui.analysis.current_mod") + " " + mod.getJarName()));
        DependenciesAnalysisGUIBase.JdepsScanResult scan = this.scanModWithJdeps(mod, jdepsPath, predicate, false);
        LinkedHashSet<String> displays = new LinkedHashSet<String>(scan.depsByDisplay.keySet());
        if (displays.isEmpty() && scan.matchedDisplay != null) {
            displays.add(scan.matchedDisplay);
        }
        if (!displays.isEmpty()) {
            this.registerDetectedModJar(mod.getJarName());
        }
        for (String display : displays) {
            int idx = foundAny.getAndIncrement();
            matchedMods.add(display);
            CrashAssistantApp.LOGGER.info("Found dependency in {} for target class '{}'.", (Object)display, (Object)this.searchOriginal);
            SwingUtilities.invokeLater(() -> {
                if (idx == 0) {
                    String header = LanguageProvider.get((String)"gui.analysis.jdeps.found").replace("$TERM$", this.searchOriginal);
                    this.appendStyledText(header, NORMAL_COLOR);
                }
                this.appendStyledText(display + "\n", MOD_COLOR);
            });
        }
        int c = completed.incrementAndGet();
        SwingUtilities.invokeLater(() -> {
            if (!isCancelled) {
                this.progressBar.setValue(c);
            }
        });
    }
}

