/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.components;

import com.google.common.collect.ImmutableList;
import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderlib.ui.layout.LineWithWidth;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.render.ComponentRenderer;
import de.ambertation.wunderlib.ui.layout.components.render.TextProvider;
import de.ambertation.wunderlib.ui.layout.values.Alignment;
import de.ambertation.wunderlib.ui.layout.values.Rectangle;
import de.ambertation.wunderlib.ui.layout.values.Value;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public class MultiLineText
extends LayoutComponent<MultiLineTextRenderer, MultiLineText> {
    Component text;
    int color = ColorHelper.DEFAULT_TEXT;
    protected MultiLineLabel multiLineLabel;
    int bufferedContentWidth = 0;
    List<LineWithWidth> lines = List.of();
    private boolean focused;

    public MultiLineText(Value width, Value height, Component text) {
        super(width, height, new MultiLineTextRenderer());
        ((MultiLineTextRenderer)this.renderer).linkedComponent = this;
        this.text = text;
        this.updatedContentWidth();
    }

    public MultiLineText setColor(int cl) {
        this.color = cl;
        return this;
    }

    public static Component parse(Component text) {
        String[] parts = text.getString().split("\\*\\*");
        if (parts.length > 0) {
            boolean bold = false;
            MutableComponent c = Component.m_237113_((String)parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                bold = !bold;
                c.m_7220_((Component)Component.m_237113_((String)parts[i]).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(bold))));
            }
            return c;
        }
        return text;
    }

    public MultiLineText setText(Component text) {
        this.text = text;
        this.updatedContentWidth();
        if (this.multiLineLabel != null) {
            this.multiLineLabel = this.createVanillaComponent();
        }
        return this;
    }

    protected MultiLineLabel createVanillaComponent() {
        int wd = this.relativeBounds == null ? this.width.calculatedSize() : this.relativeBounds.width;
        this.lines = (List)((MultiLineTextRenderer)this.renderer).getFont().m_92923_((FormattedText)this.text, wd).stream().map(component -> new LineWithWidth((FormattedCharSequence)component, ((MultiLineTextRenderer)this.renderer).getFont().m_92724_(component))).collect(ImmutableList.toImmutableList());
        return MultiLineLabel.m_94341_((Font)((MultiLineTextRenderer)this.renderer).getFont(), (FormattedText)this.text, (int)wd);
    }

    protected void updatedContentWidth() {
        String[] lines = this.text.getString().split("\n");
        if (lines.length == 0) {
            this.bufferedContentWidth = 0;
        } else {
            String line = lines[0];
            for (int i = 1; i < lines.length; ++i) {
                if (lines[i].length() <= line.length()) continue;
                line = lines[i];
            }
            this.bufferedContentWidth = ((MultiLineTextRenderer)this.renderer).getWidth((Component)Component.m_237113_((String)line));
        }
    }

    @Override
    protected void onBoundsChanged() {
        super.onBoundsChanged();
        this.multiLineLabel = this.createVanillaComponent();
    }

    @Override
    public int getContentWidth() {
        return this.bufferedContentWidth;
    }

    @Override
    public int getContentHeight() {
        return ((MultiLineTextRenderer)this.renderer).getHeight(this.text);
    }

    public boolean m_93696_() {
        return this.focused;
    }

    public void m_93692_(boolean bl) {
        this.focused = bl;
    }

    @Override
    public boolean m_5953_(double d, double e) {
        return false;
    }

    protected static class MultiLineTextRenderer
    implements ComponentRenderer,
    TextProvider {
        MultiLineText linkedComponent;

        protected MultiLineTextRenderer() {
        }

        @Override
        public int getWidth(Component c) {
            return this.getFont().m_92724_(c.m_7532_());
        }

        @Override
        public int getHeight(Component c) {
            if (this.linkedComponent == null) {
                return 20;
            }
            MultiLineLabel ml = this.linkedComponent.multiLineLabel != null ? this.linkedComponent.multiLineLabel : this.linkedComponent.createVanillaComponent();
            return ml.m_5770_() * this.getLineHeight(c);
        }

        @Override
        public void renderInBounds(GuiGraphics guiGraphics, int mouseX, int mouseY, float deltaTicks, Rectangle bounds, Rectangle clipRect) {
            if (this.linkedComponent != null && this.linkedComponent.multiLineLabel != null) {
                int top = bounds.height - this.getHeight(this.linkedComponent.text);
                if (this.linkedComponent.vAlign == Alignment.MIN) {
                    top = 0;
                }
                if (this.linkedComponent.vAlign == Alignment.CENTER) {
                    top /= 2;
                }
                if (this.linkedComponent.hAlign == Alignment.CENTER) {
                    this.linkedComponent.multiLineLabel.m_6514_(guiGraphics, bounds.width / 2, top, this.getLineHeight(this.linkedComponent.text), this.linkedComponent.color);
                } else if (this.linkedComponent.hAlign == Alignment.MAX) {
                    int lineY = 0;
                    int lineHeight = this.getLineHeight(this.linkedComponent.text);
                    for (LineWithWidth textWithWidth : this.linkedComponent.lines) {
                        guiGraphics.m_280648_(this.getFont(), textWithWidth.text(), this.linkedComponent.width.calculatedSize() - textWithWidth.width(), lineY, this.linkedComponent.color);
                        lineY += lineHeight;
                    }
                } else {
                    this.linkedComponent.multiLineLabel.m_6508_(guiGraphics, 0, top, this.getLineHeight(this.linkedComponent.text), this.linkedComponent.color);
                }
            }
        }
    }
}

