/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.worlds.together.worldPreset;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterLists;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.worlds.together.levelgen.WorldGenUtil;
import org.jetbrains.annotations.ApiStatus;

public class WorldPresets {
    private static ResourceKey<WorldPreset> DEFAULT = net.minecraft.world.level.levelgen.presets.WorldPresets.f_226437_;

    public static Holder<WorldPreset> get(RegistryAccess access, ResourceKey<WorldPreset> key) {
        return access.m_175515_(Registries.f_256729_).m_246971_(key);
    }

    public static void ensureStaticallyLoaded() {
    }

    public static ResourceKey<WorldPreset> createKey(ResourceLocation loc) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256729_, (ResourceLocation)loc);
    }

    public static ResourceKey<WorldPreset> getDEFAULT() {
        return DEFAULT;
    }

    @ApiStatus.Internal
    public static void setDEFAULT(ResourceKey<WorldPreset> DEFAULT) {
        WorldPresets.DEFAULT = DEFAULT;
    }

    public static class BootstrapData {
        public final HolderGetter<NoiseGeneratorSettings> noiseSettings;
        public final HolderGetter<Biome> biomes;
        public final HolderGetter<PlacedFeature> placedFeatures;
        public final HolderGetter<StructureSet> structureSets;
        public final LevelStem netherStem;
        public final LevelStem endStem;
        public final LevelStem overworldStem;
        public final Holder<DimensionType> netherDimensionType;
        public final Holder<DimensionType> endDimensionType;
        public final Holder<DimensionType> overworldDimensionType;
        public final WorldGenUtil.Context netherContext;
        public final WorldGenUtil.Context endContext;
        public final HolderGetter<MultiNoiseBiomeSourceParameterList> parameterLists;

        public BootstrapData(BootstapContext<WorldPreset> bootstapContext) {
            Holder.Reference endSettings;
            Holder.Reference netherSettings;
            NoiseBasedChunkGenerator nether;
            this.parameterLists = bootstapContext.m_255420_(Registries.f_273919_);
            HolderGetter dimensionTypes = bootstapContext.m_255420_(Registries.f_256787_);
            this.noiseSettings = bootstapContext.m_255420_(Registries.f_256932_);
            this.biomes = bootstapContext.m_255420_(Registries.f_256952_);
            this.placedFeatures = bootstapContext.m_255420_(Registries.f_256988_);
            this.structureSets = bootstapContext.m_255420_(Registries.f_256998_);
            this.overworldDimensionType = dimensionTypes.m_255043_(BuiltinDimensionTypes.f_223538_);
            Holder.Reference overworldParameters = this.parameterLists.m_255043_(MultiNoiseBiomeSourceParameterLists.f_273878_);
            MultiNoiseBiomeSource overworldBiomeSource = MultiNoiseBiomeSource.m_274591_((Holder)overworldParameters);
            Holder.Reference defaultOverworldNoise = this.noiseSettings.m_255043_(NoiseGeneratorSettings.f_64432_);
            this.overworldStem = this.makeNoiseBasedOverworld((BiomeSource)overworldBiomeSource, (Holder<NoiseGeneratorSettings>)defaultOverworldNoise);
            this.netherDimensionType = dimensionTypes.m_255043_(BuiltinDimensionTypes.f_223539_);
            Holder.Reference netherParameters = this.parameterLists.m_255043_(MultiNoiseBiomeSourceParameterLists.f_273830_);
            Holder.Reference defaultNetherNoise = this.noiseSettings.m_255043_(NoiseGeneratorSettings.f_64434_);
            this.netherStem = new LevelStem(this.netherDimensionType, (ChunkGenerator)new NoiseBasedChunkGenerator((BiomeSource)MultiNoiseBiomeSource.m_274591_((Holder)netherParameters), (Holder)defaultNetherNoise));
            this.endDimensionType = dimensionTypes.m_255043_(BuiltinDimensionTypes.f_223540_);
            Holder.Reference defaultEndNoise = this.noiseSettings.m_255043_(NoiseGeneratorSettings.f_64435_);
            this.endStem = new LevelStem(this.endDimensionType, (ChunkGenerator)new NoiseBasedChunkGenerator((BiomeSource)TheEndBiomeSource.m_254978_(this.biomes), (Holder)defaultEndNoise));
            ChunkGenerator chunkGenerator = this.netherStem.f_63976_();
            if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
                nether = (NoiseBasedChunkGenerator)chunkGenerator;
                netherSettings = nether.m_224341_();
            } else {
                netherSettings = this.noiseSettings.m_255043_(NoiseGeneratorSettings.f_64434_);
            }
            chunkGenerator = this.endStem.f_63976_();
            if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
                nether = (NoiseBasedChunkGenerator)chunkGenerator;
                endSettings = nether.m_224341_();
            } else {
                endSettings = this.noiseSettings.m_255043_(NoiseGeneratorSettings.f_64435_);
            }
            HolderGetter bclBiomes = bootstapContext.m_255420_(BCLBiomeRegistry.BCL_BIOMES_REGISTRY);
            this.netherContext = new WorldGenUtil.Context((Holder<DimensionType>)this.netherStem.f_63975_(), this.structureSets, (Holder<NoiseGeneratorSettings>)netherSettings);
            this.endContext = new WorldGenUtil.Context((Holder<DimensionType>)this.endStem.f_63975_(), this.structureSets, (Holder<NoiseGeneratorSettings>)endSettings);
        }

        private LevelStem makeOverworld(ChunkGenerator chunkGenerator) {
            return new LevelStem(this.overworldDimensionType, chunkGenerator);
        }

        public LevelStem makeNoiseBasedOverworld(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> holder) {
            return this.makeOverworld((ChunkGenerator)new NoiseBasedChunkGenerator(biomeSource, holder));
        }
    }
}

