/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.worlds.together.tag.v3;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagLoader;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.betterx.worlds.together.levelgen.WorldGenUtil;
import org.betterx.worlds.together.mixin.common.DiggerItemAccessor;
import org.betterx.worlds.together.tag.v3.CommonBiomeTags;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;
import org.betterx.worlds.together.tag.v3.CommonItemTags;
import org.betterx.worlds.together.tag.v3.MineableTags;
import org.betterx.worlds.together.tag.v3.TagRegistry;
import org.betterx.worlds.together.tag.v3.ToolTags;
import org.betterx.worlds.together.world.event.WorldEventsImpl;
import org.jetbrains.annotations.ApiStatus;

public class TagManager {
    private static final Map<String, TagRegistry<?>> TYPES = Maps.newHashMap();
    public static TagRegistry.RegistryBacked<Block> BLOCKS = TagManager.registerType(BuiltInRegistries.f_256975_);
    public static TagRegistry.Items ITEMS = TagManager.registerItem();
    public static TagRegistry.Biomes BIOMES = TagManager.registerBiome();

    public static <T> TagRegistry.RegistryBacked<T> registerType(DefaultedRegistry<T> registry) {
        TagRegistry.RegistryBacked type = new TagRegistry.RegistryBacked(registry);
        return (TagRegistry.RegistryBacked)TYPES.computeIfAbsent(type.directory, dir -> type);
    }

    public static TagRegistry.Items registerItem() {
        TagRegistry.Items type = new TagRegistry.Items();
        return (TagRegistry.Items)TYPES.computeIfAbsent(type.directory, dir -> type);
    }

    public static <T> TagRegistry.Simple<T> registerType(Registry<T> registry, String directory) {
        return TagManager.registerType(registry.m_123023_(), directory, o -> registry.m_7981_(o));
    }

    public static <T> TagRegistry.Simple<T> registerType(ResourceKey<? extends Registry<T>> registry, String directory, Function<T, ResourceLocation> locationProvider) {
        return (TagRegistry.Simple)TYPES.computeIfAbsent(directory, dir -> new TagRegistry.Simple(registry, (String)dir, locationProvider));
    }

    static TagRegistry.Biomes registerBiome() {
        return (TagRegistry.Biomes)TYPES.computeIfAbsent("tags/worldgen/biome", dir -> new TagRegistry.Biomes((String)dir, b -> WorldGenUtil.getBiomeID(b)));
    }

    public static <T> TagRegistry.UnTyped<T> registerType(ResourceKey<? extends Registry<T>> registry, String directory) {
        return (TagRegistry.UnTyped)TYPES.computeIfAbsent(directory, dir -> new TagRegistry.UnTyped(registry, (String)dir));
    }

    @ApiStatus.Internal
    public static void ensureStaticallyLoaded() {
        CommonItemTags.prepareTags();
        CommonBlockTags.prepareTags();
        CommonBiomeTags.prepareTags();
        MineableTags.prepareTags();
        ToolTags.prepareTags();
    }

    @ApiStatus.Internal
    public static <T> Map<ResourceLocation, List<TagLoader.EntryWithSource>> apply(String directory, Map<ResourceLocation, List<TagLoader.EntryWithSource>> tagsMap) {
        WorldEventsImpl.BEFORE_ADDING_TAGS.emit(e -> e.apply(directory, tagsMap));
        TagRegistry<?> type = TYPES.get(directory);
        if (type != null) {
            type.apply(tagsMap);
        }
        return tagsMap;
    }

    public static boolean isToolWithMineableTag(ItemStack stack, TagKey<Block> tag) {
        Item item = stack.m_41720_();
        if (item instanceof DiggerItemAccessor) {
            DiggerItemAccessor dig = (DiggerItemAccessor)item;
            return dig.bclib_getBlockTag() == tag;
        }
        return false;
    }
}

