/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.worlds.together.surfaceRules;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.betterx.worlds.together.WorldsTogether;
import org.betterx.worlds.together.surfaceRules.AssignedSurfaceRule;
import org.jetbrains.annotations.ApiStatus;

public class SurfaceRuleRegistry {
    public static final ResourceKey<Registry<AssignedSurfaceRule>> SURFACE_RULES_REGISTRY = SurfaceRuleRegistry.createRegistryKey(WorldsTogether.makeID("worldgen/betterx/surface_rules"));
    public static final Predicate<ResourceKey<LevelStem>> NON_MANAGED_DIMENSIONS = dim -> dim != LevelStem.f_63972_ && dim != LevelStem.f_63973_;
    public static final Predicate<ResourceKey<LevelStem>> ALL_DIMENSIONS = dim -> true;
    private static Map<ResourceKey<AssignedSurfaceRule>, AssignedSurfaceRule> KNOWN = new HashMap<ResourceKey<AssignedSurfaceRule>, AssignedSurfaceRule>();

    private static <T> ResourceKey<Registry<T>> createRegistryKey(ResourceLocation location) {
        return ResourceKey.m_135788_((ResourceLocation)location);
    }

    @ApiStatus.Internal
    public static void bootstrap(BootstapContext<AssignedSurfaceRule> ctx) {
        for (Map.Entry<ResourceKey<AssignedSurfaceRule>, AssignedSurfaceRule> entry : KNOWN.entrySet()) {
            ctx.m_255272_(entry.getKey(), (Object)entry.getValue());
        }
    }

    public static ResourceKey<AssignedSurfaceRule> registerRule(ResourceLocation ruleID, SurfaceRules.RuleSource rules, ResourceLocation biomeID) {
        ResourceKey key = ResourceKey.m_135785_(SURFACE_RULES_REGISTRY, (ResourceLocation)ruleID);
        KNOWN.put((ResourceKey<AssignedSurfaceRule>)key, new AssignedSurfaceRule(SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)biomeID)}), (SurfaceRules.RuleSource)rules), biomeID));
        return key;
    }

    public static void ensureStaticallyLoaded() {
    }
}

