/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.worlds.together.levelgen;

import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.worlds.together.biomesource.BiomeSourceWithConfig;
import org.betterx.worlds.together.biomesource.ReloadableBiomeSource;
import org.betterx.worlds.together.biomesource.config.BiomeSourceConfig;
import org.betterx.worlds.together.chunkgenerator.EnforceableChunkGenerator;
import org.betterx.worlds.together.tag.v3.CommonBiomeTags;
import org.betterx.worlds.together.world.event.WorldBootstrap;
import org.betterx.worlds.together.worldPreset.TogetherWorldPreset;

class BiomeRepairHelper {
    private Map<ResourceKey<LevelStem>, ChunkGenerator> vanillaDimensions = null;

    BiomeRepairHelper() {
    }

    public Registry<LevelStem> repairBiomeSourceInAllDimensions(RegistryAccess registryAccess, Registry<LevelStem> dimensionRegistry) {
        Map<ResourceKey<LevelStem>, ChunkGenerator> dimensions = TogetherWorldPreset.loadWorldDimensions();
        for (Map.Entry entry : dimensionRegistry.m_6579_()) {
            BiomeSource biomeSource;
            boolean didRepair = false;
            ResourceKey key = (ResourceKey)entry.getKey();
            LevelStem loadedStem = (LevelStem)entry.getValue();
            ChunkGenerator referenceGenerator = dimensions.get(key);
            if (referenceGenerator instanceof EnforceableChunkGenerator) {
                EnforceableChunkGenerator enforcer = (EnforceableChunkGenerator)referenceGenerator;
                ChunkGenerator loadedChunkGenerator = loadedStem.f_63976_();
                this.processBiomeTagsForDimension((ResourceKey<LevelStem>)key);
                this.registerAllBiomesFromVanillaDimension((ResourceKey<LevelStem>)key);
                if (enforcer.togetherShouldRepair(loadedChunkGenerator)) {
                    dimensionRegistry = enforcer.enforceGeneratorInWorldGenSettings(registryAccess, (ResourceKey<LevelStem>)key, (ResourceKey<DimensionType>)((ResourceKey)loadedStem.f_63975_().m_203543_().orElseThrow()), loadedChunkGenerator, dimensionRegistry);
                    didRepair = true;
                } else {
                    BiomeSource biomeSource2 = loadedChunkGenerator.m_62218_();
                    if (biomeSource2 instanceof BiomeSourceWithConfig) {
                        BiomeSourceWithConfig refSource;
                        BiomeSourceWithConfig lodedSource = (BiomeSourceWithConfig)biomeSource2;
                        BiomeSource biomeSource3 = referenceGenerator.m_62218_();
                        if (biomeSource3 instanceof BiomeSourceWithConfig && !(refSource = (BiomeSourceWithConfig)biomeSource3).getTogetherConfig().sameConfig((BiomeSourceConfig<?>)lodedSource.getTogetherConfig())) {
                            lodedSource.setTogetherConfig(refSource.getTogetherConfig());
                        }
                    }
                }
            }
            if (didRepair || !((biomeSource = loadedStem.f_63976_().m_62218_()) instanceof ReloadableBiomeSource)) continue;
            ReloadableBiomeSource reload = (ReloadableBiomeSource)biomeSource;
            reload.reloadBiomes();
        }
        return dimensionRegistry;
    }

    private void processBiomeTagsForDimension(ResourceKey<LevelStem> key) {
        if (key.equals((Object)LevelStem.f_63972_)) {
            this.preprocessBiomeTags((TagKey<Biome>)BiomeTags.f_207612_, BiomeAPI.BiomeType.NETHER);
        } else if (key.equals((Object)LevelStem.f_63973_)) {
            this.preprocessBiomeTags(CommonBiomeTags.IS_END_HIGHLAND, BiomeAPI.BiomeType.END_LAND);
            this.preprocessBiomeTags(CommonBiomeTags.IS_END_MIDLAND, BiomeAPI.BiomeType.END_LAND);
            this.preprocessBiomeTags(CommonBiomeTags.IS_END_BARRENS, BiomeAPI.BiomeType.END_BARRENS);
            this.preprocessBiomeTags(CommonBiomeTags.IS_SMALL_END_ISLAND, BiomeAPI.BiomeType.END_VOID);
            this.preprocessBiomeTags(CommonBiomeTags.IS_END_CENTER, BiomeAPI.BiomeType.END_CENTER);
            this.preprocessBiomeTags((TagKey<Biome>)BiomeTags.f_215818_, BiomeAPI.BiomeType.END_LAND);
        }
    }

    private void preprocessBiomeTags(TagKey<Biome> tag, BiomeAPI.BiomeType targetType) {
        if (WorldBootstrap.getLastRegistryAccess() != null) {
            WorldBootstrap.getLastRegistryAccess().m_6632_(tag.f_203867_()).map(r -> r.m_206058_(tag)).ifPresent(iter -> {
                for (Holder biomeHolder : iter) {
                    BCLBiomeRegistry.registerIfUnknown((Holder<Biome>)biomeHolder, targetType);
                }
            });
        }
    }

    private void registerAllBiomesFromVanillaDimension(ResourceKey<LevelStem> key) {
        BiomeAPI.BiomeType type = BiomeAPI.BiomeType.getMainBiomeTypeForDimension(key);
        if (type != null) {
            ChunkGenerator vanillaDim;
            if (this.vanillaDimensions == null) {
                this.vanillaDimensions = TogetherWorldPreset.getDimensionsMap((ResourceKey<WorldPreset>)WorldPresets.f_226437_);
            }
            if ((vanillaDim = (ChunkGenerator)this.vanillaDimensions.getOrDefault(key, null)) != null && vanillaDim.m_62218_() != null) {
                for (Holder biomeHolder : vanillaDim.m_62218_().m_207840_()) {
                    BCLBiomeRegistry.registerIfUnknown((Holder<Biome>)biomeHolder, type);
                }
            }
        }
    }
}

