/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import org.betterx.bclib.util.MHelper;
import org.sinytra.connector.mod.ConnectorMod;

public class StructureHelper {
    public static StructureTemplate readStructure(ResourceLocation resource) {
        String ns = resource.m_135827_();
        String nm = resource.m_135815_();
        return StructureHelper.readStructure("/data/" + ns + "/structures/" + nm + ".nbt");
    }

    public static StructureTemplate readStructure(File datapack, String path) {
        if (datapack.isDirectory()) {
            return StructureHelper.readStructure(datapack + "/" + path);
        }
        if (datapack.isFile() && datapack.getName().endsWith(".zip")) {
            try {
                ZipFile zipFile = new ZipFile(datapack);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    long compressedSize = entry.getCompressedSize();
                    long normalSize = entry.getSize();
                    String type = entry.isDirectory() ? "DIR" : "FILE";
                    System.out.println(name);
                    System.out.format("\t %s - %d - %d\n", type, compressedSize, normalSize);
                }
                zipFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static StructureTemplate readStructure(String path) {
        try {
            InputStream inputstream = ConnectorMod.getModResourceAsStream(StructureHelper.class, (String)path);
            return StructureHelper.readStructureFromStream(inputstream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static StructureTemplate readStructureFromStream(InputStream stream) throws IOException {
        CompoundTag nbttagcompound = NbtIo.m_128939_((InputStream)stream);
        StructureTemplate template = new StructureTemplate();
        template.m_246595_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), nbttagcompound);
        return template;
    }

    public static BlockPos offsetPos(BlockPos pos, StructureTemplate structure, Rotation rotation, Mirror mirror) {
        Vec3 offset = StructureTemplate.m_74578_((Vec3)Vec3.m_82512_((Vec3i)structure.m_163801_()), (Mirror)mirror, (Rotation)rotation, (BlockPos)BlockPos.f_121853_);
        return pos.m_7918_((int)(-offset.f_82479_ * 0.5), 0, (int)(-offset.f_82481_ * 0.5));
    }

    public static void placeCenteredBottom(WorldGenLevel world, BlockPos pos, StructureTemplate structure, Rotation rotation, Mirror mirror, RandomSource random) {
        StructureHelper.placeCenteredBottom(world, pos, structure, rotation, mirror, StructureHelper.makeBox(pos), random);
    }

    public static void placeCenteredBottom(WorldGenLevel world, BlockPos pos, StructureTemplate structure, Rotation rotation, Mirror mirror, BoundingBox bounds, RandomSource random) {
        BlockPos offset = StructureHelper.offsetPos(pos, structure, rotation, mirror);
        StructurePlaceSettings placementData = new StructurePlaceSettings().m_74379_(rotation).m_74377_(mirror).m_74381_(bounds);
        structure.m_230328_((ServerLevelAccessor)world, offset, offset, placementData, random, 4);
    }

    private static BoundingBox makeBox(BlockPos pos) {
        int sx = (pos.m_123341_() >> 4 << 4) - 16;
        int sz = (pos.m_123343_() >> 4 << 4) - 16;
        int ex = sx + 47;
        int ez = sz + 47;
        return BoundingBox.m_162375_((Vec3i)new Vec3i(sx, 0, sz), (Vec3i)new Vec3i(ex, 255, ez));
    }

    public static BoundingBox getStructureBounds(BlockPos pos, StructureTemplate structure, Rotation rotation, Mirror mirror) {
        Vec3i max = structure.m_163801_();
        Vec3 min = StructureTemplate.m_74578_((Vec3)Vec3.m_82512_((Vec3i)structure.m_163801_()), (Mirror)mirror, (Rotation)rotation, (BlockPos)BlockPos.f_121853_);
        max = max.m_7918_((int)(-min.f_82479_), (int)(-min.f_82480_), (int)(-min.f_82481_));
        return BoundingBox.m_162375_((Vec3i)pos.m_7918_((int)min.f_82479_, (int)min.f_82480_, (int)min.f_82481_), (Vec3i)max.m_121955_((Vec3i)pos));
    }

    public static BoundingBox intersectBoxes(BoundingBox box1, BoundingBox box2) {
        int x1 = MHelper.max(box1.m_162395_(), box2.m_162395_());
        int y1 = MHelper.max(box1.m_162396_(), box2.m_162396_());
        int z1 = MHelper.max(box1.m_162398_(), box2.m_162398_());
        int x2 = MHelper.min(box1.m_162399_(), box2.m_162399_());
        int y2 = MHelper.min(box1.m_162400_(), box2.m_162400_());
        int z2 = MHelper.min(box1.m_162401_(), box2.m_162401_());
        return BoundingBox.m_162375_((Vec3i)new Vec3i(x1, y1, z1), (Vec3i)new Vec3i(x2, y2, z2));
    }
}

