/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.betterx.bclib.BCLib;
import org.jetbrains.annotations.Nullable;

public class ItemUtil {
    @Nullable
    public static ItemStack fromStackString(String stackString) {
        if (stackString == null || stackString.equals("")) {
            return null;
        }
        try {
            String[] parts = stackString.split(":");
            if (parts.length < 2) {
                return null;
            }
            if (parts.length == 2) {
                ResourceLocation itemId = new ResourceLocation(stackString);
                Item item = (Item)BuiltInRegistries.f_257033_.m_6612_(itemId).orElseThrow(() -> new IllegalStateException("Output item " + itemId + " does not exists!"));
                return new ItemStack((ItemLike)item);
            }
            ResourceLocation itemId = new ResourceLocation(parts[0], parts[1]);
            Item item = (Item)BuiltInRegistries.f_257033_.m_6612_(itemId).orElseThrow(() -> new IllegalStateException("Output item " + itemId + " does not exists!"));
            return new ItemStack((ItemLike)item, Integer.valueOf(parts[2]).intValue());
        }
        catch (Exception ex) {
            BCLib.LOGGER.error("ItemStack deserialization error!", ex);
            return null;
        }
    }

    public static CompoundTag readNBT(JsonObject recipe) {
        if (recipe.has("nbt")) {
            try {
                String nbtData = GsonHelper.m_13906_((JsonObject)recipe, (String)"nbt");
                CompoundTag nbt = TagParser.m_129359_((String)nbtData);
                return nbt;
            }
            catch (CommandSyntaxException ex) {
                BCLib.LOGGER.warning("Error parsing nbt data for output.", new Object[]{ex});
            }
        }
        return null;
    }

    public static void writeNBT(JsonObject root, CompoundTag nbt) {
        if (nbt != null) {
            String nbtData = nbt.toString();
            root.addProperty("nbt", nbtData);
        }
    }

    public static Ingredient fromJsonIngredientWithNBT(JsonObject ingredient) {
        Ingredient ing = Ingredient.m_43917_((JsonElement)ingredient);
        CompoundTag nbt = ItemUtil.readNBT(ingredient);
        if (nbt != null && !ing.m_43947_()) {
            ing.m_43908_()[0].m_41751_(nbt);
        }
        return ing;
    }

    public static ItemStack fromJsonRecipeWithNBT(JsonObject recipe) {
        ItemStack output = ItemUtil.fromJsonRecipe(recipe);
        CompoundTag nbt = ItemUtil.readNBT(recipe);
        if (output != null && nbt != null) {
            output.m_41751_(nbt);
        }
        return output;
    }

    @Nullable
    public static ItemStack fromJsonRecipe(JsonObject recipe) {
        try {
            if (!recipe.has("item")) {
                throw new IllegalStateException("Invalid JsonObject. Entry 'item' does not exists!");
            }
            ResourceLocation itemId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)recipe, (String)"item"));
            Item item = (Item)BuiltInRegistries.f_257033_.m_6612_(itemId).orElseThrow(() -> new IllegalStateException("Output item " + itemId + " does not exists!"));
            int count = GsonHelper.m_13824_((JsonObject)recipe, (String)"count", (int)1);
            return new ItemStack((ItemLike)item, count);
        }
        catch (Exception ex) {
            BCLib.LOGGER.error("ItemStack deserialization error!", ex);
            return null;
        }
    }

    public static JsonElement toJsonIngredientWithNBT(Ingredient ing) {
        JsonElement el = ing.m_43942_();
        if (el.isJsonObject() && !ing.m_43947_() && ing.m_43908_()[0].m_41782_()) {
            JsonObject obj = el.getAsJsonObject();
            ItemUtil.writeNBT(obj, ing.m_43908_()[0].m_41783_());
        }
        return el;
    }

    public static JsonObject toJsonRecipeWithNBT(ItemStack stack) {
        return ItemUtil.toJsonRecipeWithNBT((ItemLike)stack.m_41720_(), stack.m_41613_(), stack.m_41783_());
    }

    public static JsonObject toJsonRecipeWithNBT(ItemLike item, int count, CompoundTag nbt) {
        JsonObject root = ItemUtil.toJsonRecipe(item, count);
        ItemUtil.writeNBT(root, nbt);
        return root;
    }

    public static JsonObject toJsonRecipe(ItemStack stack) {
        return ItemUtil.toJsonRecipe((ItemLike)stack.m_41720_(), stack.m_41613_());
    }

    public static JsonObject toJsonRecipe(ItemLike item, int count) {
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_());
        if (id == null) {
            throw new IllegalStateException("Unknown Item " + item);
        }
        JsonObject root = new JsonObject();
        root.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_()).toString());
        if (count > 1) {
            root.addProperty("count", (Number)count);
        }
        return root;
    }
}

