/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.sdf;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.betterx.bclib.api.v2.levelgen.structures.StructureWorld;
import org.betterx.bclib.sdf.PosInfo;
import org.betterx.bclib.util.BlocksHelper;

public abstract class SDF {
    private final List<Function<PosInfo, BlockState>> postProcesses = Lists.newArrayList();
    private Function<BlockState, Boolean> canReplace = state -> state.m_247087_();

    public abstract float getDistance(float var1, float var2, float var3);

    public abstract BlockState getBlockState(BlockPos var1);

    public SDF addPostProcess(Function<PosInfo, BlockState> postProcess) {
        this.postProcesses.add(postProcess);
        return this;
    }

    public SDF setReplaceFunction(Function<BlockState, Boolean> canReplace) {
        this.canReplace = canReplace;
        return this;
    }

    public void fillRecursive(ServerLevelAccessor world, BlockPos start) {
        HashMap mapWorld = Maps.newHashMap();
        HashMap addInfo = Maps.newHashMap();
        HashSet blocks = Sets.newHashSet();
        HashSet ends = Sets.newHashSet();
        HashSet add = Sets.newHashSet();
        ends.add(new BlockPos(0, 0, 0));
        BlockPos.MutableBlockPos bPos = new BlockPos.MutableBlockPos();
        for (boolean run = true; run; run &= !ends.isEmpty()) {
            for (BlockPos center : ends) {
                for (Direction dir : Direction.values()) {
                    bPos.m_122190_((Vec3i)center).m_122173_(dir);
                    BlockPos wpos = bPos.m_121955_((Vec3i)start);
                    if (blocks.contains(bPos) || !this.canReplace.apply(world.m_8055_(wpos)).booleanValue() || !(this.getDistance(bPos.m_123341_(), bPos.m_123342_(), bPos.m_123343_()) < 0.0f)) continue;
                    BlockState state = this.getBlockState(wpos);
                    PosInfo.create(mapWorld, addInfo, wpos).setState(state);
                    add.add(bPos.m_7949_());
                }
            }
            blocks.addAll(ends);
            ends.clear();
            ends.addAll(add);
            add.clear();
        }
        ArrayList infos = new ArrayList(mapWorld.values());
        if (infos.size() > 0) {
            Collections.sort(infos);
            this.postProcesses.forEach(postProcess -> infos.forEach(info -> info.setState((BlockState)postProcess.apply(info))));
            infos.forEach(info -> BlocksHelper.setWithoutUpdate((LevelAccessor)world, info.getPos(), info.getState()));
            infos.clear();
            infos.addAll(addInfo.values());
            Collections.sort(infos);
            this.postProcesses.forEach(postProcess -> infos.forEach(info -> info.setState((BlockState)postProcess.apply(info))));
            infos.forEach(info -> {
                if (this.canReplace.apply(world.m_8055_(info.getPos())).booleanValue()) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, info.getPos(), info.getState());
                }
            });
        }
    }

    public void fillArea(ServerLevelAccessor world, BlockPos center, AABB box) {
        HashMap mapWorld = Maps.newHashMap();
        HashMap addInfo = Maps.newHashMap();
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        int y = (int)box.f_82289_;
        while ((double)y <= box.f_82292_) {
            mut.m_142448_(y);
            int x = (int)box.f_82288_;
            while ((double)x <= box.f_82291_) {
                mut.m_142451_(x);
                int z = (int)box.f_82290_;
                while ((double)z <= box.f_82293_) {
                    BlockPos fpos;
                    mut.m_142443_(z);
                    if (this.canReplace.apply(world.m_8055_((BlockPos)mut)).booleanValue() && this.getDistance((fpos = mut.m_121996_((Vec3i)center)).m_123341_(), fpos.m_123342_(), fpos.m_123343_()) < 0.0f) {
                        PosInfo.create(mapWorld, addInfo, mut.m_7949_()).setState(this.getBlockState((BlockPos)mut));
                    }
                    ++z;
                }
                ++x;
            }
            ++y;
        }
        ArrayList infos = new ArrayList(mapWorld.values());
        if (infos.size() > 0) {
            Collections.sort(infos);
            this.postProcesses.forEach(postProcess -> infos.forEach(info -> info.setState((BlockState)postProcess.apply(info))));
            infos.forEach(info -> BlocksHelper.setWithoutUpdate((LevelAccessor)world, info.getPos(), info.getState()));
            infos.clear();
            infos.addAll(addInfo.values());
            Collections.sort(infos);
            this.postProcesses.forEach(postProcess -> infos.forEach(info -> info.setState((BlockState)postProcess.apply(info))));
            infos.forEach(info -> {
                if (this.canReplace.apply(world.m_8055_(info.getPos())).booleanValue()) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, info.getPos(), info.getState());
                }
            });
        }
    }

    public void fillRecursiveIgnore(ServerLevelAccessor world, BlockPos start, Function<BlockState, Boolean> ignore) {
        HashMap mapWorld = Maps.newHashMap();
        HashMap addInfo = Maps.newHashMap();
        HashSet blocks = Sets.newHashSet();
        HashSet ends = Sets.newHashSet();
        HashSet add = Sets.newHashSet();
        ends.add(new BlockPos(0, 0, 0));
        BlockPos.MutableBlockPos bPos = new BlockPos.MutableBlockPos();
        for (boolean run = true; run; run &= !ends.isEmpty()) {
            for (BlockPos center : ends) {
                for (Direction dir : Direction.values()) {
                    bPos.m_122190_((Vec3i)center).m_122173_(dir);
                    BlockPos wpos = bPos.m_121955_((Vec3i)start);
                    BlockState state = world.m_8055_(wpos);
                    boolean ign = ignore.apply(state);
                    if (blocks.contains(bPos) || !ign && !this.canReplace.apply(state).booleanValue() || !(this.getDistance(bPos.m_123341_(), bPos.m_123342_(), bPos.m_123343_()) < 0.0f)) continue;
                    PosInfo.create(mapWorld, addInfo, wpos).setState(ign ? state : this.getBlockState((BlockPos)bPos));
                    add.add(bPos.m_7949_());
                }
            }
            blocks.addAll(ends);
            ends.clear();
            ends.addAll(add);
            add.clear();
        }
        ArrayList infos = new ArrayList(mapWorld.values());
        if (infos.size() > 0) {
            Collections.sort(infos);
            this.postProcesses.forEach(postProcess -> infos.forEach(info -> info.setState((BlockState)postProcess.apply(info))));
            infos.forEach(info -> BlocksHelper.setWithoutUpdate((LevelAccessor)world, info.getPos(), info.getState()));
            infos.clear();
            infos.addAll(addInfo.values());
            Collections.sort(infos);
            this.postProcesses.forEach(postProcess -> infos.forEach(info -> info.setState((BlockState)postProcess.apply(info))));
            infos.forEach(info -> {
                if (this.canReplace.apply(world.m_8055_(info.getPos())).booleanValue()) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, info.getPos(), info.getState());
                }
            });
        }
    }

    public void fillRecursive(StructureWorld world, BlockPos start) {
        HashMap mapWorld = Maps.newHashMap();
        HashMap addInfo = Maps.newHashMap();
        HashSet blocks = Sets.newHashSet();
        HashSet ends = Sets.newHashSet();
        HashSet add = Sets.newHashSet();
        ends.add(new BlockPos(0, 0, 0));
        BlockPos.MutableBlockPos bPos = new BlockPos.MutableBlockPos();
        for (boolean run = true; run; run &= !ends.isEmpty()) {
            for (BlockPos center : ends) {
                for (Direction dir : Direction.values()) {
                    bPos.m_122190_((Vec3i)center).m_122173_(dir);
                    BlockPos wpos = bPos.m_121955_((Vec3i)start);
                    if (blocks.contains(bPos) || !(this.getDistance(bPos.m_123341_(), bPos.m_123342_(), bPos.m_123343_()) < 0.0f)) continue;
                    BlockState state = this.getBlockState(wpos);
                    PosInfo.create(mapWorld, addInfo, wpos).setState(state);
                    add.add(bPos.m_7949_());
                }
            }
            blocks.addAll(ends);
            ends.clear();
            ends.addAll(add);
            add.clear();
        }
        ArrayList infos = new ArrayList(mapWorld.values());
        Collections.sort(infos);
        this.postProcesses.forEach(postProcess -> infos.forEach(info -> info.setState((BlockState)postProcess.apply(info))));
        infos.forEach(info -> world.setBlock(info.getPos(), info.getState()));
        infos.clear();
        infos.addAll(addInfo.values());
        Collections.sort(infos);
        this.postProcesses.forEach(postProcess -> infos.forEach(info -> info.setState((BlockState)postProcess.apply(info))));
        infos.forEach(info -> world.setBlock(info.getPos(), info.getState()));
    }

    public Set<BlockPos> getPositions(ServerLevelAccessor world, BlockPos start) {
        HashSet blocks = Sets.newHashSet();
        HashSet ends = Sets.newHashSet();
        HashSet add = Sets.newHashSet();
        ends.add(new BlockPos(0, 0, 0));
        BlockPos.MutableBlockPos bPos = new BlockPos.MutableBlockPos();
        for (boolean run = true; run; run &= !ends.isEmpty()) {
            for (BlockPos center : ends) {
                for (Direction dir : Direction.values()) {
                    bPos.m_122190_((Vec3i)center).m_122173_(dir);
                    BlockPos wpos = bPos.m_121955_((Vec3i)start);
                    BlockState state = world.m_8055_(wpos);
                    if (blocks.contains(wpos) || !this.canReplace.apply(state).booleanValue() || !(this.getDistance(bPos.m_123341_(), bPos.m_123342_(), bPos.m_123343_()) < 0.0f)) continue;
                    add.add(bPos.m_7949_());
                }
            }
            ends.forEach(end -> blocks.add(end.m_121955_((Vec3i)start)));
            ends.clear();
            ends.addAll(add);
            add.clear();
        }
        return blocks;
    }
}

