/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.recipes.AbstractSingleInputRecipeBuilder;
import org.betterx.bclib.util.ItemUtil;
import org.betterx.bclib.util.RecipeHelper;

public abstract class AbstractDoubleInputRecipeBuilder<T extends AbstractDoubleInputRecipeBuilder, R extends Recipe<? extends Container>>
extends AbstractSingleInputRecipeBuilder<T, R> {
    protected Ingredient secondaryInput;

    protected AbstractDoubleInputRecipeBuilder(ResourceLocation id, ItemLike output) {
        super(id, output);
    }

    public T setSecondaryInput(ItemLike ... inputs) {
        for (ItemLike item : inputs) {
            this.alright &= RecipeHelper.exists(item);
        }
        this.secondaryInput = Ingredient.m_43929_((ItemLike[])inputs);
        return (T)this;
    }

    public T setSecondaryInput(TagKey<Item> input) {
        this.secondaryInput = Ingredient.m_204132_(input);
        return (T)this;
    }

    public T setSecondaryInputAndUnlock(TagKey<Item> input) {
        this.setPrimaryInput(input);
        this.unlockedBy((TagKey)input);
        return (T)this;
    }

    public T setSecondaryInputAndUnlock(ItemLike ... inputs) {
        this.setSecondaryInput(inputs);
        for (ItemLike item : inputs) {
            this.unlockedBy(item);
        }
        return (T)this;
    }

    @Override
    protected boolean checkRecipe() {
        if (this.secondaryInput == null) {
            BCLib.LOGGER.warning("Secondary input for Recipe can't be 'null', recipe {} will be ignored!", this.id);
            return false;
        }
        return super.checkRecipe();
    }

    @Override
    protected void serializeRecipeData(JsonObject root) {
        JsonArray ingredients = new JsonArray();
        ingredients.add(this.primaryInput.m_43942_());
        ingredients.add(this.secondaryInput.m_43942_());
        root.add("ingredients", (JsonElement)ingredients);
        if (this.group != null && !this.group.isEmpty()) {
            root.addProperty("group", this.group);
        }
        root.add("result", (JsonElement)ItemUtil.toJsonRecipe(this.output));
    }
}

