/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.items.complex;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.ItemLike;
import org.betterx.bclib.items.complex.EquipmentDescription;
import org.betterx.bclib.items.complex.EquipmentSlot;
import org.betterx.bclib.registry.ItemRegistry;
import org.jetbrains.annotations.NotNull;

public abstract class EquipmentSet {
    public final Tier material;
    public final String baseName;
    public final String modID;
    public final ItemLike stick;
    public static final EquipmentSlot PICKAXE_SLOT = new EquipmentSlot("pickaxe", RecipeCategory.TOOLS);
    public static final EquipmentSlot AXE_SLOT = new EquipmentSlot("axe", RecipeCategory.TOOLS);
    public static final EquipmentSlot SHOVEL_SLOT = new EquipmentSlot("shovel", RecipeCategory.TOOLS);
    public static final EquipmentSlot SWORD_SLOT = new EquipmentSlot("sword", RecipeCategory.COMBAT);
    public static final EquipmentSlot HOE_SLOT = new EquipmentSlot("hoe", RecipeCategory.TOOLS);
    public static final EquipmentSlot SHEARS_SLOT = new EquipmentSlot("shears", RecipeCategory.TOOLS);
    public static final EquipmentSlot HELMET_SLOT = new EquipmentSlot("helmet", RecipeCategory.COMBAT);
    public static final EquipmentSlot CHESTPLATE_SLOT = new EquipmentSlot("chestplate", RecipeCategory.COMBAT);
    public static final EquipmentSlot LEGGINGS_SLOT = new EquipmentSlot("leggings", RecipeCategory.COMBAT);
    public static final EquipmentSlot BOOTS_SLOT = new EquipmentSlot("boots", RecipeCategory.COMBAT);
    public final SetValues attackDamage;
    public final SetValues attackSpeed;
    private final Map<EquipmentSlot, EquipmentDescription<?>> descriptions = new HashMap();
    protected final EquipmentSet sourceSet;

    public EquipmentSet(Tier material, String modID, String baseName, ItemLike stick, SetValues attackDamage, SetValues attackSpeed) {
        this(material, modID, baseName, stick, null, attackDamage, attackSpeed);
    }

    public EquipmentSet(Tier material, String modID, String baseName, ItemLike stick, EquipmentSet sourceSet, SetValues attackDamage, SetValues attackSpeed) {
        this.material = material;
        this.baseName = baseName;
        this.modID = modID;
        this.stick = stick;
        this.attackDamage = attackDamage;
        this.attackSpeed = attackSpeed;
        this.sourceSet = sourceSet;
    }

    protected <I extends Item> void add(EquipmentSlot slot, EquipmentDescription<I> desc) {
        this.descriptions.put(slot, desc);
    }

    protected <I extends Item> void add(EquipmentSlot slot, EquipmentSet baseSet, ItemDescriptorCreator<I> descriptor, ItemCreator<I> item) {
        EquipmentDescription<Item> desc = descriptor.build(slot, (Item)baseSet.getSlot(slot), tier -> item.build((Tier)tier, this.attackDamage.get(slot), this.attackSpeed.get(slot)));
        this.descriptions.put(slot, desc);
    }

    protected <I extends Item> void add(EquipmentSlot slot, DescriptorCreator<I> descriptor, ItemCreator<I> item) {
        EquipmentDescription<Item> desc = descriptor.build(slot, tier -> item.build((Tier)tier, this.attackDamage.get(slot), this.attackSpeed.get(slot)));
        this.descriptions.put(slot, desc);
    }

    public EquipmentSet init(ItemRegistry itemsRegistry) {
        for (Map.Entry<EquipmentSlot, EquipmentDescription<?>> desc : this.descriptions.entrySet()) {
            desc.getValue().init(this.buildID(desc), itemsRegistry, this.material, this.stick, this.sourceSet);
        }
        return this;
    }

    @NotNull
    protected ResourceLocation buildID(Map.Entry<EquipmentSlot, EquipmentDescription<?>> desc) {
        return new ResourceLocation(this.modID, this.baseName + "_" + desc.getKey().name());
    }

    public <I extends Item> I getSlot(EquipmentSlot slot) {
        return (I)this.descriptions.get(slot).getItem();
    }

    public static class SetValues {
        private final Map<EquipmentSlot, Float> values = new HashMap<EquipmentSlot, Float>();

        private SetValues() {
        }

        public static SetValues create() {
            return new SetValues();
        }

        public static SetValues copy(SetValues source, float offset) {
            SetValues v = SetValues.create();
            for (Map.Entry<EquipmentSlot, Float> e : source.values.entrySet()) {
                v.add(e.getKey(), e.getValue().floatValue() + offset);
            }
            return v;
        }

        public SetValues add(EquipmentSlot slot, float value) {
            this.values.put(slot, Float.valueOf(value));
            return this;
        }

        public SetValues offset(EquipmentSlot slot, float offset) {
            this.values.put(slot, Float.valueOf(this.get(slot) + offset));
            return this;
        }

        public float get(EquipmentSlot slot) {
            return this.values.getOrDefault(slot, Float.valueOf(0.0f)).floatValue();
        }
    }

    public static interface ItemCreator<I extends Item> {
        public I build(Tier var1, float var2, float var3);
    }

    public static interface ItemDescriptorCreator<I extends Item> {
        public EquipmentDescription<I> build(EquipmentSlot var1, Item var2, Function<Tier, I> var3);
    }

    public static interface DescriptorCreator<I extends Item> {
        public EquipmentDescription<I> build(EquipmentSlot var1, Function<Tier, I> var2);
    }

    public static class AttackSpeed {
        public static SetValues WOOD_LEVEL = SetValues.create().add(SWORD_SLOT, -2.4f).add(SHOVEL_SLOT, -3.0f).add(PICKAXE_SLOT, -2.8f).add(AXE_SLOT, -3.2f).add(HOE_SLOT, -3.0f);
        public static SetValues STONE_LEVEL = SetValues.create().add(SWORD_SLOT, -2.4f).add(SHOVEL_SLOT, -3.0f).add(PICKAXE_SLOT, -2.8f).add(AXE_SLOT, -3.2f).add(HOE_SLOT, -2.0f);
        public static SetValues GOLDEN_LEVEL = SetValues.create().add(SWORD_SLOT, -2.4f).add(SHOVEL_SLOT, -3.0f).add(PICKAXE_SLOT, -2.8f).add(AXE_SLOT, -3.0f).add(HOE_SLOT, -3.0f);
        public static SetValues IRON_LEVEL = SetValues.create().add(SWORD_SLOT, -2.4f).add(SHOVEL_SLOT, -3.0f).add(PICKAXE_SLOT, -2.8f).add(AXE_SLOT, -3.1f).add(HOE_SLOT, -1.0f);
        public static SetValues DIAMOND_LEVEL;
        public static SetValues NETHERITE_LEVEL;

        static {
            NETHERITE_LEVEL = DIAMOND_LEVEL = SetValues.create().add(SWORD_SLOT, -2.4f).add(SHOVEL_SLOT, -3.0f).add(PICKAXE_SLOT, -2.8f).add(AXE_SLOT, -3.0f).add(HOE_SLOT, 0.0f);
        }
    }

    public static class AttackDamage {
        public static SetValues WOOD_LEVEL = SetValues.create().add(SWORD_SLOT, 3.0f).add(SHOVEL_SLOT, 1.5f).add(PICKAXE_SLOT, 1.0f).add(AXE_SLOT, 6.0f).add(HOE_SLOT, 0.0f);
        public static SetValues STONE_LEVEL = SetValues.create().add(SWORD_SLOT, 3.0f).add(SHOVEL_SLOT, 1.5f).add(PICKAXE_SLOT, 1.0f).add(AXE_SLOT, 7.0f).add(HOE_SLOT, -1.0f);
        public static SetValues GOLDEN_LEVEL = SetValues.create().add(SWORD_SLOT, 3.0f).add(SHOVEL_SLOT, 1.5f).add(PICKAXE_SLOT, 1.0f).add(AXE_SLOT, 6.0f).add(HOE_SLOT, 0.0f);
        public static SetValues IRON_LEVEL = SetValues.create().add(SWORD_SLOT, 3.0f).add(SHOVEL_SLOT, 1.5f).add(PICKAXE_SLOT, 1.0f).add(AXE_SLOT, 6.0f).add(HOE_SLOT, -2.0f);
        public static SetValues DIAMOND_LEVEL = SetValues.create().add(SWORD_SLOT, 3.0f).add(SHOVEL_SLOT, 1.5f).add(PICKAXE_SLOT, 1.0f).add(AXE_SLOT, 5.0f).add(HOE_SLOT, -3.0f);
        public static SetValues NETHERITE_LEVEL = SetValues.create().add(SWORD_SLOT, 3.0f).add(SHOVEL_SLOT, 1.5f).add(PICKAXE_SLOT, 1.0f).add(AXE_SLOT, 5.0f).add(HOE_SLOT, -4.0f);
    }
}

