/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.items.complex;

import java.util.function.Function;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.betterx.bclib.items.BaseArmorItem;
import org.betterx.bclib.items.complex.EquipmentSet;
import org.betterx.bclib.items.complex.EquipmentSlot;
import org.betterx.bclib.items.complex.SmithingSet;
import org.betterx.bclib.recipes.BCLRecipeBuilder;
import org.betterx.bclib.recipes.CraftingRecipeBuilder;
import org.betterx.bclib.recipes.SmithingRecipeBuilder;
import org.betterx.bclib.registry.ItemRegistry;
import org.jetbrains.annotations.Nullable;

public class EquipmentDescription<I extends Item> {
    private final Function<Tier, I> creator;
    private I item;
    public final EquipmentSlot slot;

    public EquipmentDescription(EquipmentSlot slot, Function<Tier, I> creator) {
        this.creator = creator;
        this.slot = slot;
    }

    public void init(ResourceLocation id, ItemRegistry itemsRegistry, Tier material, ItemLike stick, @Nullable EquipmentSet sourceSet) {
        this.item = (Item)this.creator.apply(material);
        itemsRegistry.registerTool(id, (Item)this.item);
        this.addRecipe(id, (Item)this.item, material, stick, sourceSet);
    }

    public void addRecipe(ResourceLocation id, Item tool, Tier material, ItemLike stick, @Nullable EquipmentSet sourceSet) {
        SmithingSet smit;
        if (material == null) {
            return;
        }
        Ingredient repair = material.m_6282_();
        if (repair == null) {
            return;
        }
        ItemStack[] repairItems = repair.m_43908_();
        if (repairItems == null || repairItems.length == 0) {
            return;
        }
        Item ingot = repairItems[0].m_41720_();
        if (material instanceof SmithingSet && (smit = (SmithingSet)material).getSmithingTemplateItem() != null && sourceSet != null) {
            SmithingRecipeBuilder builder = (SmithingRecipeBuilder)((SmithingRecipeBuilder)BCLRecipeBuilder.smithing(id, (ItemLike)tool).setTemplate((Item)smit.getSmithingTemplateItem()).setPrimaryInput(new ItemLike[]{sourceSet.getSlot(this.slot)})).setAdditionAndUnlock((ItemLike)ingot).setCategory(this.slot.category());
            builder.build();
        } else {
            CraftingRecipeBuilder builder = (CraftingRecipeBuilder)BCLRecipeBuilder.crafting(id, (ItemLike)tool).addMaterial('#', new ItemLike[]{ingot}).setCategory(RecipeCategory.TOOLS);
            if (this.buildRecipe(tool, stick, builder)) {
                return;
            }
            builder.setGroup(id.m_135815_()).build();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean buildRecipe(Item tool, ItemLike stick, CraftingRecipeBuilder builder) {
        if (tool instanceof ShearsItem) {
            builder.setShape(" #", "# ");
            return false;
        } else if (tool instanceof BaseArmorItem) {
            BaseArmorItem bai = (BaseArmorItem)tool;
            if (bai.m_266204_().m_266308_() == net.minecraft.world.entity.EquipmentSlot.FEET) {
                builder.setShape("# #", "# #");
                return false;
            } else if (bai.m_266204_().m_266308_() == net.minecraft.world.entity.EquipmentSlot.HEAD) {
                builder.setShape("###", "# #");
                return false;
            } else if (bai.m_266204_().m_266308_() == net.minecraft.world.entity.EquipmentSlot.CHEST) {
                builder.setShape("# #", "###", "###");
                return false;
            } else {
                if (bai.m_266204_().m_266308_() != net.minecraft.world.entity.EquipmentSlot.LEGS) return true;
                builder.setShape("###", "# #", "# #");
            }
            return false;
        } else {
            builder.addMaterial('I', stick);
            if (tool instanceof PickaxeItem) {
                builder.setShape("###", " I ", " I ");
                return false;
            } else if (tool instanceof AxeItem) {
                builder.setShape("##", "#I", " I");
                return false;
            } else if (tool instanceof HoeItem) {
                builder.setShape("##", " I", " I");
                return false;
            } else if (tool instanceof ShovelItem) {
                builder.setShape("#", "I", "I");
                return false;
            } else {
                if (!(tool instanceof SwordItem)) return true;
                builder.setShape("#", "#", "I");
            }
        }
        return false;
    }

    public I getItem() {
        return this.item;
    }
}

