/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.config;

import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import org.betterx.bclib.config.Config;
import org.betterx.bclib.config.ConfigKeeper;
import org.betterx.bclib.config.ConfigKey;
import org.jetbrains.annotations.Nullable;

public class IdConfig
extends Config {
    protected final BiFunction<ResourceLocation, String, ConfigKey> keyFactory;

    public IdConfig(String modID, String group, BiFunction<ResourceLocation, String, ConfigKey> keyFactory) {
        super(modID, group);
        this.keyFactory = keyFactory;
    }

    @Override
    protected void registerEntries() {
    }

    protected ConfigKey createKey(ResourceLocation id, String key) {
        return this.keyFactory.apply(id, key);
    }

    @Nullable
    public <T, E extends ConfigKeeper.Entry<T>> E getEntry(ResourceLocation id, String key, Class<E> type) {
        return this.getEntry(this.createKey(id, key), type);
    }

    @Nullable
    public <T, E extends ConfigKeeper.Entry<T>> T getDefault(ResourceLocation id, String key, Class<E> type) {
        return this.getDefault(this.createKey(id, key), type);
    }

    public String getString(ResourceLocation id, String key, String defaultValue) {
        return this.getString(this.createKey(id, key), defaultValue);
    }

    public String getString(ResourceLocation id, String key) {
        return this.getString(this.createKey(id, key));
    }

    public boolean setString(ResourceLocation id, String key, String value) {
        return this.setString(this.createKey(id, key), value);
    }

    public int getInt(ResourceLocation id, String key, int defaultValue) {
        return this.getInt(this.createKey(id, key), defaultValue);
    }

    public int getInt(ResourceLocation id, String key) {
        return this.getInt(this.createKey(id, key));
    }

    public boolean setInt(ResourceLocation id, String key, int value) {
        return this.setInt(this.createKey(id, key), value);
    }

    public boolean setRangedInt(ResourceLocation id, String key, int value) {
        return this.setRanged(this.createKey(id, key), value, ConfigKeeper.IntegerRange.class);
    }

    public boolean setRangedFloat(ResourceLocation id, String key, float value) {
        return this.setRanged(this.createKey(id, key), Float.valueOf(value), ConfigKeeper.FloatRange.class);
    }

    public float getFloat(ResourceLocation id, String key, float defaultValue) {
        return this.getFloat(this.createKey(id, key), defaultValue);
    }

    public float getFloat(ResourceLocation id, String key) {
        return this.getFloat(this.createKey(id, key));
    }

    public boolean setFloat(ResourceLocation id, String key, float value) {
        return this.setFloat(this.createKey(id, key), value);
    }

    public boolean getBoolean(ResourceLocation id, String key, boolean defaultValue) {
        return this.getBoolean(this.createKey(id, key), defaultValue);
    }

    public boolean getBoolean(ResourceLocation id, String key) {
        return this.getBoolean(this.createKey(id, key));
    }

    public boolean setBoolean(ResourceLocation id, String key, boolean value) {
        return this.setBoolean(this.createKey(id, key), value);
    }
}

