/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.complexmaterials;

import java.util.Objects;
import net.fabricmc.fabric.api.object.builder.v1.block.type.BlockSetTypeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.block.type.WoodTypeRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;

public final class BCLWoodTypeWrapper {
    public final ResourceLocation id;
    public final WoodType type;
    public final MapColor color;
    public final boolean flammable;

    protected BCLWoodTypeWrapper(ResourceLocation id, WoodType type, MapColor color, boolean flammable) {
        this.id = id;
        this.type = type;
        this.color = color;
        this.flammable = flammable;
    }

    public static Builder create(String modID, String string) {
        return new Builder(new ResourceLocation(modID, string));
    }

    public static Builder create(ResourceLocation id) {
        return new Builder(id);
    }

    public BlockSetType setType() {
        return this.type.f_271340_();
    }

    public ResourceLocation id() {
        return this.id;
    }

    public WoodType type() {
        return this.type;
    }

    public MapColor color() {
        return this.color;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BCLWoodTypeWrapper that = (BCLWoodTypeWrapper)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.type, that.type) && Objects.equals(this.color, that.color);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.color);
    }

    public String toString() {
        return "BCLWoodTypeWrapper[id=" + this.id + ", type=" + this.type + ", color=" + this.color + "]";
    }

    public static class Builder {
        private final ResourceLocation id;
        private BlockSetType setType;
        private MapColor color;
        private boolean flammable;

        public Builder(ResourceLocation id) {
            this.id = id;
            this.color = MapColor.f_283825_;
            this.flammable = true;
        }

        public Builder setBlockSetType(BlockSetType setType) {
            this.setType = setType;
            return this;
        }

        public Builder setColor(MapColor color) {
            this.color = color;
            return this;
        }

        public Builder setFlammable(boolean flammable) {
            this.flammable = flammable;
            return this;
        }

        public BCLWoodTypeWrapper build() {
            if (this.setType == null) {
                this.setType = BlockSetTypeRegistry.registerWood((ResourceLocation)this.id);
            }
            WoodType type = WoodTypeRegistry.register((ResourceLocation)this.id, (BlockSetType)this.setType);
            return new BCLWoodTypeWrapper(this.id, type, this.color, this.flammable);
        }
    }
}

