/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.render;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.blockentities.BaseChestBlockEntity;
import org.betterx.bclib.client.models.BaseChestBlockModel;

@Environment(value=EnvType.CLIENT)
public class BaseChestBlockEntityRenderer
implements BlockEntityRenderer<BaseChestBlockEntity> {
    private static final HashMap<Block, RenderType[]> LAYERS = Maps.newHashMap();
    private static final RenderType[] RENDER_TYPES = new RenderType[]{RenderType.m_110452_((ResourceLocation)new ResourceLocation("textures/entity/chest/normal.png")), RenderType.m_110452_((ResourceLocation)new ResourceLocation("textures/entity/chest/normal_left.png")), RenderType.m_110452_((ResourceLocation)new ResourceLocation("textures/entity/chest/normal_right.png"))};
    private static final int ID_NORMAL = 0;
    private static final int ID_LEFT = 1;
    private static final int ID_RIGHT = 2;
    private final BaseChestBlockModel chestModel = new BaseChestBlockModel(BaseChestBlockModel.getTexturedModelData().m_171564_());

    public BaseChestBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(BaseChestBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        Level world = entity.m_58904_();
        boolean worldExists = world != null;
        BlockState blockState = worldExists ? entity.m_58900_() : (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.SOUTH);
        ChestType chestType = blockState.m_61138_((Property)ChestBlock.f_51479_) ? (ChestType)blockState.m_61143_((Property)ChestBlock.f_51479_) : ChestType.SINGLE;
        Block block = blockState.m_60734_();
        if (block instanceof AbstractChestBlock) {
            AbstractChestBlock abstractChestBlock = (AbstractChestBlock)block;
            boolean isDouble = chestType != ChestType.SINGLE;
            float f = ((Direction)blockState.m_61143_((Property)ChestBlock.f_51478_)).m_122435_();
            matrices.m_85836_();
            matrices.m_85837_(0.5, 0.5, 0.5);
            matrices.m_252781_(Axis.f_252436_.m_252977_(-f));
            matrices.m_85837_(-0.5, -0.5, -0.5);
            DoubleBlockCombiner.NeighborCombineResult propertySource = worldExists ? abstractChestBlock.m_5641_(blockState, world, entity.m_58899_(), true) : DoubleBlockCombiner.Combiner::m_6502_;
            float pitch = ((Float2FloatFunction)propertySource.m_5649_(ChestBlock.m_51517_((LidBlockEntity)entity))).get(tickDelta);
            pitch = 1.0f - pitch;
            pitch = 1.0f - pitch * pitch * pitch;
            int blockLight = ((Int2IntFunction)propertySource.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(light);
            VertexConsumer vertexConsumer = BaseChestBlockEntityRenderer.getConsumer(vertexConsumers, block, chestType);
            if (isDouble) {
                if (chestType == ChestType.LEFT) {
                    this.renderParts(matrices, vertexConsumer, this.chestModel.partLeftA, this.chestModel.partLeftB, this.chestModel.partLeftC, pitch, blockLight, overlay);
                } else {
                    this.renderParts(matrices, vertexConsumer, this.chestModel.partRightA, this.chestModel.partRightB, this.chestModel.partRightC, pitch, blockLight, overlay);
                }
            } else {
                this.renderParts(matrices, vertexConsumer, this.chestModel.partA, this.chestModel.partB, this.chestModel.partC, pitch, blockLight, overlay);
            }
            matrices.m_85849_();
        }
    }

    private void renderParts(PoseStack matrices, VertexConsumer vertices, ModelPart modelPart, ModelPart modelPart2, ModelPart modelPart3, float pitch, int light, int overlay) {
        modelPart2.f_104203_ = modelPart.f_104203_ = -(pitch * 1.5707964f);
        modelPart.m_104301_(matrices, vertices, light, overlay);
        modelPart2.m_104301_(matrices, vertices, light, overlay);
        modelPart3.m_104301_(matrices, vertices, light, overlay);
    }

    private static RenderType getChestTexture(ChestType type, RenderType[] layers) {
        return switch (type) {
            case ChestType.LEFT -> layers[1];
            case ChestType.RIGHT -> layers[2];
            default -> layers[0];
        };
    }

    public static VertexConsumer getConsumer(MultiBufferSource provider, Block block, ChestType chestType) {
        RenderType[] layers = LAYERS.getOrDefault(block, RENDER_TYPES);
        return provider.m_6299_(BaseChestBlockEntityRenderer.getChestTexture(chestType, layers));
    }

    public static void registerRenderLayer(Block block) {
        ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        String modId = blockId.m_135827_();
        String path = blockId.m_135815_();
        LAYERS.put(block, new RenderType[]{RenderType.m_110452_((ResourceLocation)new ResourceLocation(modId, "textures/entity/chest/" + path + ".png")), RenderType.m_110452_((ResourceLocation)new ResourceLocation(modId, "textures/entity/chest/" + path + "_left.png")), RenderType.m_110452_((ResourceLocation)new ResourceLocation(modId, "textures/entity/chest/" + path + "_right.png"))});
    }
}

