/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourVine;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.LootUtil;

public class BaseVineBlock
extends BaseBlockNotFull
implements RenderLayerProvider,
BonemealableBlock,
BehaviourVine {
    public static final EnumProperty<BlockProperties.TripleShape> SHAPE = BlockProperties.TRIPLE_SHAPE;
    private static final VoxelShape VOXEL_SHAPE = BaseVineBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public BaseVineBlock() {
        this(0, false);
    }

    public BaseVineBlock(int light) {
        this(light, false);
    }

    public BaseVineBlock(int light, boolean bottomOnly) {
        this(light, bottomOnly, p -> p);
    }

    public BaseVineBlock(int light, boolean bottomOnly, Function<BlockBehaviour.Properties, BlockBehaviour.Properties> propMod) {
        this(propMod.apply(BehaviourBuilders.createPlant().m_60918_(SoundType.f_56740_).m_60953_(state -> bottomOnly ? (state.m_61143_(SHAPE) == BlockProperties.TripleShape.BOTTOM ? light : 0) : light).m_222979_(BlockBehaviour.OffsetType.XZ)));
    }

    public BaseVineBlock(BlockBehaviour.Properties properties) {
        super(properties.m_222979_(BlockBehaviour.OffsetType.XZ));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{SHAPE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        Vec3 vec3d = state.m_60824_(view, pos);
        return VOXEL_SHAPE.m_83216_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
    }

    public boolean canGenerate(BlockState state, LevelReader world, BlockPos pos) {
        return this.isSupport(state, world, pos);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return this.isSupport(state, world, pos);
    }

    protected boolean isSupport(BlockState state, LevelReader world, BlockPos pos) {
        BlockState up = world.m_8055_(pos.m_7494_());
        return up.m_60713_((Block)this) || up.m_204336_(BlockTags.f_13035_) || BaseVineBlock.m_49863_((LevelReader)world, (BlockPos)pos.m_7494_(), (Direction)Direction.DOWN);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.m_7898_(state, (LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (world.m_8055_(pos.m_7495_()).m_60734_() != this) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM));
        }
        if (world.m_8055_(pos.m_7494_()).m_60734_() != this) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP));
        }
        return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BlockProperties.TripleShape.MIDDLE));
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ItemStack tool = (ItemStack)builder.m_287261_(LootContextParams.f_81463_);
        if (LootUtil.isCorrectTool((ItemLike)this, state, tool) || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool) > 0) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this)});
        }
        return Lists.newArrayList();
    }

    @Override
    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        while (world.m_8055_(pos).m_60734_() == this) {
            pos = pos.m_7495_();
        }
        return world.m_8055_(pos).m_60795_();
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        while (level.m_8055_(pos).m_60734_() == this) {
            pos = pos.m_7495_();
        }
        return level.m_46859_(pos);
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        while (level.m_8055_(pos).m_60734_() == this) {
            pos = pos.m_7495_();
        }
        level.m_46597_(pos, this.m_49966_());
        BlocksHelper.setWithoutUpdate((LevelAccessor)level, pos, this.m_49966_());
    }
}

