/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.client.models.BasePatterns;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.TagProvider;
import org.jetbrains.annotations.Nullable;

public abstract class BaseFenceBlock
extends FenceBlock
implements BlockModelProvider,
TagProvider,
DropSelfLootProvider<BaseFenceBlock> {
    private final Block parent;

    protected BaseFenceBlock(Block source) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)source).m_60955_());
        this.parent = source;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BlockModel getItemModel(ResourceLocation blockId) {
        ResourceLocation parentId = BuiltInRegistries.f_256975_.m_7981_((Object)this.parent);
        Optional<String> pattern = PatternsHelper.createJson(BasePatterns.ITEM_FENCE, parentId);
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public BlockModel getBlockModel(ResourceLocation blockId, BlockState blockState) {
        ResourceLocation parentId = BuiltInRegistries.f_256975_.m_7981_((Object)this.parent);
        String path = blockId.m_135815_();
        Optional<String> pattern = Optional.empty();
        if (path.endsWith("_post")) {
            pattern = PatternsHelper.createJson(BasePatterns.BLOCK_FENCE_POST, parentId);
        }
        if (path.endsWith("_side")) {
            pattern = PatternsHelper.createJson(BasePatterns.BLOCK_FENCE_SIDE, parentId);
        }
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public UnbakedModel getModelVariant(ResourceLocation stateId, BlockState blockState, Map<ResourceLocation, UnbakedModel> modelCache) {
        ResourceLocation postId = new ResourceLocation(stateId.m_135827_(), "block/" + stateId.m_135815_() + "_post");
        ResourceLocation sideId = new ResourceLocation(stateId.m_135827_(), "block/" + stateId.m_135815_() + "_side");
        this.registerBlockModel(postId, postId, blockState, modelCache);
        this.registerBlockModel(sideId, sideId, blockState, modelCache);
        ModelsHelper.MultiPartBuilder builder = ModelsHelper.MultiPartBuilder.create((StateDefinition<Block, BlockState>)this.f_49792_);
        builder.part(sideId).setCondition(state -> (Boolean)state.m_61143_((Property)f_52309_)).setUVLock(true).add();
        builder.part(sideId).setCondition(state -> (Boolean)state.m_61143_((Property)f_52310_)).setTransformation(BlockModelRotation.X0_Y90.m_6189_()).setUVLock(true).add();
        builder.part(sideId).setCondition(state -> (Boolean)state.m_61143_((Property)f_52311_)).setTransformation(BlockModelRotation.X0_Y180.m_6189_()).setUVLock(true).add();
        builder.part(sideId).setCondition(state -> (Boolean)state.m_61143_((Property)f_52312_)).setTransformation(BlockModelRotation.X0_Y270.m_6189_()).setUVLock(true).add();
        builder.part(postId).add();
        return builder.build();
    }

    @Override
    public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
        blockTags.add((TagKey<Block>)BlockTags.f_13039_);
        itemTags.add((TagKey<Item>)ItemTags.f_13147_);
    }

    public static BaseFenceBlock from(Block source, BlockSetType type) {
        return new Wood(source, type);
    }

    public static class Wood
    extends BaseFenceBlock
    implements BehaviourWood {
        public Wood(Block source, BlockSetType type) {
            super(source);
        }

        @Override
        public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
            super.addTags(blockTags, itemTags);
            blockTags.add((TagKey<Block>)BlockTags.f_13098_);
            itemTags.add((TagKey<Item>)ItemTags.f_13176_);
        }
    }
}

