/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.LootUtil;

public abstract class BaseDoublePlantBlock
extends BaseBlockNotFull
implements RenderLayerProvider,
BonemealableBlock {
    private static final VoxelShape SHAPE = BaseDoublePlantBlock.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final IntegerProperty ROTATION = BlockProperties.ROTATION;
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");

    public BaseDoublePlantBlock() {
        this(BehaviourBuilders.createPlant().m_60918_(SoundType.f_56740_).m_222979_(BlockBehaviour.OffsetType.NONE));
    }

    public BaseDoublePlantBlock(int light) {
        this(BehaviourBuilders.createPlant().m_60918_(SoundType.f_56740_).m_60953_(state -> (Boolean)state.m_61143_((Property)TOP) != false ? light : 0).m_222979_(BlockBehaviour.OffsetType.NONE));
    }

    public BaseDoublePlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{TOP, ROTATION});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        Vec3 vec3d = state.m_60824_(view, pos);
        return SHAPE.m_83216_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockState down = world.m_8055_(pos.m_7495_());
        BlockState up = world.m_8055_(pos.m_7494_());
        return ((Boolean)state.m_61143_((Property)TOP)).booleanValue() ? down.m_60734_() == this : this.isTerrain(down) && up.m_247087_();
    }

    public boolean canStayAt(BlockState state, LevelReader world, BlockPos pos) {
        BlockState down = world.m_8055_(pos.m_7495_());
        BlockState up = world.m_8055_(pos.m_7494_());
        return ((Boolean)state.m_61143_((Property)TOP)).booleanValue() ? down.m_60734_() == this : this.isTerrain(down) && up.m_60734_() == this;
    }

    protected abstract boolean isTerrain(BlockState var1);

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.canStayAt(state, (LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ItemStack tool = (ItemStack)builder.m_287261_(LootContextParams.f_81463_);
        if (LootUtil.isCorrectTool((ItemLike)this, state, tool) || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool) > 0) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this)});
        }
        return Lists.newArrayList();
    }

    @Override
    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public boolean m_7370_(LevelReader levelReader, BlockPos blockPos, BlockState blockState, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        ItemEntity item = new ItemEntity((Level)level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)this));
        level.m_7967_((Entity)item);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        int rot = world.f_46441_.m_188503_(4);
        BlockState bs = (BlockState)this.m_49966_().m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(rot));
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, pos, bs);
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, pos.m_7494_(), (BlockState)bs.m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true)));
    }
}

