/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.levelgen.features.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import org.betterx.bclib.api.v3.levelgen.features.placement.PlacementModifiers;

public class Stencil
extends PlacementModifier {
    public static final Codec<Stencil> CODEC;
    private static final Boolean[] BN_STENCIL;
    private final List<Boolean> stencil;
    private static final Stencil DEFAULT;
    private static final Stencil DEFAULT4;
    private final int selectOneIn;

    private static List<Boolean> convert(Boolean[] s) {
        return Arrays.stream(s).toList();
    }

    public Stencil(Boolean[] stencil, int selectOneIn) {
        this(Stencil.convert(stencil), selectOneIn);
    }

    public Stencil(List<Boolean> stencil, int selectOneIn) {
        this.stencil = stencil;
        this.selectOneIn = selectOneIn;
    }

    public static Stencil all() {
        return DEFAULT;
    }

    public static Stencil oneIn4() {
        return DEFAULT4;
    }

    public Stream<BlockPos> m_213676_(PlacementContext placementContext, RandomSource randomSource, BlockPos blockPos) {
        ArrayList<BlockPos> pos = new ArrayList<BlockPos>(256);
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                if (!this.stencil.get(x << 4 | y).booleanValue()) continue;
                pos.add(blockPos.m_7918_(x, 0, y));
            }
        }
        return pos.stream();
    }

    public PlacementModifierType<?> m_183327_() {
        return PlacementModifiers.STENCIL;
    }

    static {
        BN_STENCIL = new Boolean[]{false, true, false, false, false, false, false, true, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, true, false, false, false, false, true, true, false, false, true, true, true, false, false, false, true, true, false, false, false, true, false, false, true, true, true, false, false, true, true, true, true, false, true, true, true, true, false, false, false, true, true, false, false, true, true, true, false, false, false, false, false, true, false, false, false, false, true, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, true, true, true, true, false, false, false, true, true, true, true, false, false, false, true, true, false, true, true, true, true, true, true, true, false, false, true, true, false, true, true, false, false, false, true, false, false, true, false, false, false, false, false, true, true, true, false, false, false, false, true, false, false, true, false, false, false, false, false, false, true, false, false, false, false, true, false, false, false, true, true, false, false, false, false, false, true, false, false, false, false, true, false, true, false, false, false, true, false, false, false, false, true, false, false, false, false, true, false, true, true, false, false, true, false, false, false, true, true, true, true, true, true, false, true, false, true, true, true, true, true, true, true, false, false, false, false, true, false, false, false, false, true, true, false, false, false, true, false, false, false, false, false, true, true, false, false};
        DEFAULT = new Stencil(BN_STENCIL, 1);
        DEFAULT4 = new Stencil(BN_STENCIL, 4);
        CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.m_144637_((Codec)Codec.BOOL.listOf()).fieldOf("structures").orElse(Stencil.convert(BN_STENCIL)).forGetter(a -> a.stencil), (App)Codec.INT.fieldOf("one_in").orElse((Object)1).forGetter(a -> a.selectOneIn)).apply((Applicative)instance, Stencil::new));
    }
}

