/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.levelgen.features.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import org.betterx.bclib.api.v3.levelgen.features.placement.PlacementModifiers;

public class InBiome
extends PlacementFilter {
    public static final Codec<InBiome> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("negate").orElse((Object)false).forGetter(cfg -> cfg.negate), (App)Codec.list((Codec)ResourceLocation.f_135803_).fieldOf("biomes").forGetter(cfg -> cfg.biomeIDs)).apply((Applicative)instance, InBiome::new));
    public final List<ResourceLocation> biomeIDs;
    public final boolean negate;

    protected InBiome(boolean negate, List<ResourceLocation> biomeIDs) {
        this.biomeIDs = biomeIDs;
        this.negate = negate;
    }

    public static InBiome matchingID(ResourceLocation ... id) {
        return new InBiome(false, List.of(id));
    }

    public static InBiome matchingID(List<ResourceLocation> ids) {
        return new InBiome(false, ids);
    }

    public static InBiome notMatchingID(ResourceLocation ... id) {
        return new InBiome(true, List.of(id));
    }

    public static InBiome notMatchingID(List<ResourceLocation> ids) {
        return new InBiome(true, ids);
    }

    protected boolean m_213917_(PlacementContext ctx, RandomSource random, BlockPos pos) {
        Holder holder = ctx.m_191831_().m_204166_(pos);
        Optional<ResourceLocation> biomeLocation = holder.m_203543_().map(key -> key.m_135782_());
        if (biomeLocation.isPresent()) {
            boolean contains = this.biomeIDs.contains(biomeLocation.get());
            return this.negate != contains;
        }
        return false;
    }

    public PlacementModifierType<InBiome> m_183327_() {
        return PlacementModifiers.IN_BIOME;
    }
}

