/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.levelgen.features;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountOnEveryLayerPlacement;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightmapPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.betterx.bclib.api.v3.levelgen.features.BCLFeature;
import org.betterx.bclib.api.v3.levelgen.features.BCLFeatureBuilder;
import org.betterx.bclib.api.v3.levelgen.features.blockpredicates.BlockPredicates;
import org.betterx.bclib.api.v3.levelgen.features.config.PlaceFacingBlockConfig;
import org.betterx.bclib.api.v3.levelgen.features.placement.All;
import org.betterx.bclib.api.v3.levelgen.features.placement.Extend;
import org.betterx.bclib.api.v3.levelgen.features.placement.FindSolidInDirection;
import org.betterx.bclib.api.v3.levelgen.features.placement.ForAll;
import org.betterx.bclib.api.v3.levelgen.features.placement.InBiome;
import org.betterx.bclib.api.v3.levelgen.features.placement.Is;
import org.betterx.bclib.api.v3.levelgen.features.placement.IsBasin;
import org.betterx.bclib.api.v3.levelgen.features.placement.IsNextTo;
import org.betterx.bclib.api.v3.levelgen.features.placement.NoiseFilter;
import org.betterx.bclib.api.v3.levelgen.features.placement.Offset;
import org.betterx.bclib.api.v3.levelgen.features.placement.OnEveryLayer;
import org.betterx.bclib.api.v3.levelgen.features.placement.Stencil;
import org.betterx.bclib.api.v3.levelgen.features.placement.UnderEveryLayer;

abstract class CommonPlacedFeatureBuilder<F extends Feature<FC>, FC extends FeatureConfiguration, T extends CommonPlacedFeatureBuilder<F, FC, T>> {
    protected final List<PlacementModifier> modifications = new LinkedList<PlacementModifier>();

    CommonPlacedFeatureBuilder() {
    }

    public T modifier(PlacementModifier ... modifiers) {
        for (PlacementModifier m : modifiers) {
            this.modifications.add(m);
        }
        return (T)this;
    }

    public T modifier(List<PlacementModifier> modifiers) {
        this.modifications.addAll(modifiers);
        return (T)this;
    }

    public T count(int count) {
        return this.modifier(new PlacementModifier[]{CountPlacement.m_191628_((int)count)});
    }

    public T countMax(int count) {
        return this.modifier(new PlacementModifier[]{CountPlacement.m_191630_((IntProvider)UniformInt.m_146622_((int)0, (int)count))});
    }

    public T countRange(int min, int max) {
        return this.modifier(new PlacementModifier[]{CountPlacement.m_191630_((IntProvider)UniformInt.m_146622_((int)min, (int)max))});
    }

    public T all() {
        return this.modifier(All.simple());
    }

    public T stencil() {
        return this.modifier(Stencil.all());
    }

    public T stencilOneIn4() {
        return this.modifier(Stencil.oneIn4());
    }

    public T onEveryLayer(int count) {
        return this.modifier(new PlacementModifier[]{CountOnEveryLayerPlacement.m_191604_((int)count)});
    }

    public T onEveryLayerMax(int count) {
        return this.modifier(new PlacementModifier[]{CountOnEveryLayerPlacement.m_191606_((IntProvider)UniformInt.m_146622_((int)0, (int)count))});
    }

    public T onEveryLayer() {
        return this.modifier(OnEveryLayer.simple());
    }

    public T onEveryLayerMin4() {
        return this.modifier(OnEveryLayer.min4());
    }

    public T underEveryLayer() {
        return this.modifier(UnderEveryLayer.simple());
    }

    public T underEveryLayerMin4() {
        return this.modifier(UnderEveryLayer.min4());
    }

    public T onceEvery(int n) {
        return this.modifier(new PlacementModifier[]{RarityFilter.m_191900_((int)n)});
    }

    public T onlyInBiome() {
        return this.modifier(new PlacementModifier[]{BiomeFilter.m_191561_()});
    }

    public T noiseIn(double min, double max, float scaleXZ, float scaleY) {
        return this.modifier(new PlacementModifier[]{new NoiseFilter((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189267_, min, max, scaleXZ, scaleY)});
    }

    public T noiseAbove(double value, float scaleXZ, float scaleY) {
        return this.modifier(new PlacementModifier[]{new NoiseFilter((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189267_, value, Double.MAX_VALUE, scaleXZ, scaleY)});
    }

    public T noiseBelow(double value, float scaleXZ, float scaleY) {
        return this.modifier(new PlacementModifier[]{new NoiseFilter((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189267_, -1.7976931348623157E308, value, scaleXZ, scaleY)});
    }

    public T squarePlacement() {
        return this.modifier(new PlacementModifier[]{InSquarePlacement.m_191715_()});
    }

    public T onHeightmap(Heightmap.Types types) {
        return this.modifier(new PlacementModifier[]{HeightmapPlacement.m_191702_((Heightmap.Types)types)});
    }

    public T randomHeight10FromFloorCeil() {
        return this.modifier(PlacementUtils.f_195357_);
    }

    public T randomHeight4FromFloorCeil() {
        return this.modifier(PlacementUtils.f_195359_);
    }

    public T randomHeight8FromFloorCeil() {
        return this.modifier(PlacementUtils.f_195358_);
    }

    public T randomHeight() {
        return this.modifier(PlacementUtils.f_195356_);
    }

    public T spreadHorizontal(IntProvider p) {
        return this.modifier(new PlacementModifier[]{RandomOffsetPlacement.m_191891_((IntProvider)p)});
    }

    public T spreadVertical(IntProvider p) {
        return this.modifier(new PlacementModifier[]{RandomOffsetPlacement.m_191891_((IntProvider)p)});
    }

    public T spread(IntProvider horizontal, IntProvider vertical) {
        return this.modifier(new PlacementModifier[]{RandomOffsetPlacement.m_191879_((IntProvider)horizontal, (IntProvider)vertical)});
    }

    public T offset(Direction dir) {
        return this.modifier(Offset.inDirection(dir));
    }

    public T offset(Vec3i dir) {
        return this.modifier(new Offset(dir));
    }

    public T findSolidFloor(int distance) {
        return this.modifier(FindSolidInDirection.down(distance));
    }

    public T noiseBasedCount(float noiseLevel, int belowNoiseCount, int aboveNoiseCount) {
        return this.modifier(new PlacementModifier[]{NoiseThresholdCountPlacement.m_191756_((double)noiseLevel, (int)belowNoiseCount, (int)aboveNoiseCount)});
    }

    public T extendDown(int min, int max) {
        return this.modifier(new Extend(Direction.DOWN, (IntProvider)UniformInt.m_146622_((int)min, (int)max)));
    }

    public T inBasinOf(BlockPredicate ... predicates) {
        return this.modifier(new PlacementModifier[]{new IsBasin(BlockPredicate.m_190430_((BlockPredicate[])predicates))});
    }

    public T inOpenBasinOf(BlockPredicate ... predicates) {
        return this.modifier(new PlacementModifier[]{IsBasin.openTop(BlockPredicate.m_190430_((BlockPredicate[])predicates))});
    }

    public T is(BlockPredicate ... predicates) {
        return this.modifier(new PlacementModifier[]{new Is(BlockPredicate.m_190430_((BlockPredicate[])predicates), Optional.empty())});
    }

    public T isAbove(BlockPredicate ... predicates) {
        return this.modifier(new PlacementModifier[]{new Is(BlockPredicate.m_190430_((BlockPredicate[])predicates), Optional.of(Direction.DOWN.m_122436_()))});
    }

    public T isUnder(BlockPredicate ... predicates) {
        return this.modifier(new PlacementModifier[]{new Is(BlockPredicate.m_190430_((BlockPredicate[])predicates), Optional.of(Direction.UP.m_122436_()))});
    }

    public T findSolidCeil(int distance) {
        return this.modifier(FindSolidInDirection.up(distance));
    }

    public T findSolidSurface(Direction dir, int distance) {
        return this.modifier(new FindSolidInDirection(dir, distance, 0));
    }

    public T findSolidSurface(List<Direction> dir, int distance, boolean randomSelect) {
        return this.modifier(new FindSolidInDirection(dir, distance, randomSelect, 0));
    }

    public T onWalls(int distance, int depth) {
        return this.modifier(new FindSolidInDirection(PlaceFacingBlockConfig.HORIZONTAL, distance, false, depth));
    }

    public T heightmap() {
        return this.modifier(PlacementUtils.f_195352_);
    }

    public T heightmapTopSolid() {
        return this.modifier(PlacementUtils.f_195353_);
    }

    public T heightmapWorldSurface() {
        return this.modifier(PlacementUtils.f_195354_);
    }

    public T extendXZ(int xzSpread) {
        UniformInt xz = UniformInt.m_146622_((int)0, (int)xzSpread);
        return this.modifier(new ForAll(List.of(new Extend(Direction.NORTH, (IntProvider)xz), new Extend(Direction.SOUTH, (IntProvider)xz), new Extend(Direction.EAST, (IntProvider)xz), new Extend(Direction.WEST, (IntProvider)xz))), new ForAll(List.of(new Extend(Direction.EAST, (IntProvider)xz), new Extend(Direction.WEST, (IntProvider)xz), new Extend(Direction.NORTH, (IntProvider)xz), new Extend(Direction.SOUTH, (IntProvider)xz))));
    }

    public T extendXYZ(int xzSpread, int ySpread) {
        UniformInt xz = UniformInt.m_146622_((int)0, (int)xzSpread);
        return ((CommonPlacedFeatureBuilder)this.extendXZ(xzSpread)).extendDown(1, ySpread);
    }

    public T isEmpty() {
        return this.modifier(new PlacementModifier[]{BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.f_190393_)});
    }

    public T is(BlockPredicate predicate) {
        return this.modifier(new PlacementModifier[]{BlockPredicateFilter.m_191576_((BlockPredicate)predicate)});
    }

    public T isNextTo(BlockPredicate predicate) {
        return this.modifier(new PlacementModifier[]{new IsNextTo(predicate)});
    }

    public T belowIsNextTo(BlockPredicate predicate) {
        return this.modifier(new PlacementModifier[]{new IsNextTo(predicate, Direction.DOWN.m_122436_())});
    }

    public T isNextTo(BlockPredicate predicate, Vec3i offset) {
        return this.modifier(new PlacementModifier[]{new IsNextTo(predicate, offset)});
    }

    public T isOn(BlockPredicate predicate) {
        return this.modifier(new PlacementModifier[]{Is.below(predicate)});
    }

    public T inBiomes(ResourceLocation ... biomeID) {
        return this.modifier(new PlacementModifier[]{InBiome.matchingID(biomeID)});
    }

    public T notInBiomes(ResourceLocation ... biomeID) {
        return this.modifier(new PlacementModifier[]{InBiome.notMatchingID(biomeID)});
    }

    public T isEmptyAndOn(BlockPredicate predicate) {
        return ((CommonPlacedFeatureBuilder)this.isEmpty()).isOn(predicate);
    }

    public T isEmptyAndOnNylium() {
        return this.isEmptyAndOn(BlockPredicates.ONLY_NYLIUM);
    }

    public T isEmptyAndOnNetherGround() {
        return this.isEmptyAndOn(BlockPredicates.ONLY_NETHER_GROUND);
    }

    public T isUnder(BlockPredicate predicate) {
        return this.modifier(new PlacementModifier[]{Is.above(predicate)});
    }

    public T isEmptyAndUnder(BlockPredicate predicate) {
        return ((CommonPlacedFeatureBuilder)this.isEmpty()).isUnder(predicate);
    }

    public T isEmptyAndUnderNylium() {
        return this.isEmptyAndUnder(BlockPredicates.ONLY_NYLIUM);
    }

    public T isEmptyAndUnderNetherGround() {
        return this.isEmptyAndUnder(BlockPredicates.ONLY_NETHER_GROUND);
    }

    public T vanillaNetherGround(int countPerLayer) {
        return ((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)this.randomHeight4FromFloorCeil()).onlyInBiome()).onEveryLayer(countPerLayer)).onlyInBiome();
    }

    public T betterNetherGround(int countPerLayer) {
        return ((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)this.randomHeight4FromFloorCeil()).count(countPerLayer)).squarePlacement()).onlyInBiome()).onEveryLayerMin4()).onlyInBiome();
    }

    public T betterNetherCeiling(int countPerLayer) {
        return ((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)this.randomHeight4FromFloorCeil()).count(countPerLayer)).squarePlacement()).onlyInBiome()).underEveryLayerMin4()).onlyInBiome();
    }

    public T betterNetherOnWall(int countPerLayer) {
        return ((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)this.count(countPerLayer)).squarePlacement()).randomHeight4FromFloorCeil()).onlyInBiome()).onWalls(16, 0);
    }

    public T betterNetherInWall(int countPerLayer) {
        return ((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)((CommonPlacedFeatureBuilder)this.count(countPerLayer)).squarePlacement()).randomHeight4FromFloorCeil()).onlyInBiome()).onWalls(16, 1);
    }

    abstract BCLFeature.Unregistered<F, FC> build();

    public BCLFeatureBuilder.RandomPatch inRandomPatch(ResourceLocation id) {
        return BCLFeatureBuilder.startRandomPatch(id, this.build().getPlacedFeature());
    }

    public BCLFeatureBuilder.RandomPatch randomBonemealDistribution(ResourceLocation id) {
        return this.inRandomPatch(id).tries(9).spreadXZ(3).spreadY(1);
    }
}

