/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.datagen;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import org.betterx.bclib.api.v3.datagen.RegistrySupplier;
import org.betterx.worlds.together.util.Logger;

public abstract class RegistriesDataProvider
implements DataProvider {
    protected final RegistrySupplier registries;
    protected final PackOutput output;
    protected final Logger LOGGER;
    protected final CompletableFuture<HolderLookup.Provider> registriesFuture;

    protected RegistriesDataProvider(Logger logger, RegistrySupplier registries, FabricDataOutput generator, CompletableFuture<HolderLookup.Provider> registriesFuture) {
        this.LOGGER = logger;
        this.output = generator;
        this.registriesFuture = registriesFuture;
        this.registries = registries;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cachedOutput) {
        this.LOGGER.info("Serialize Registries " + this.registries.defaultModIDs);
        return this.registriesFuture.thenCompose(registriesProvider -> CompletableFuture.supplyAsync(() -> this.registries).thenCompose(entries -> {
            this.registries.acquireLock();
            RegistryOps dynamicOps = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registriesProvider);
            CompletableFuture[] futures = (CompletableFuture[])entries.allRegistries.stream().map(registryData -> this.serializeRegistry(cachedOutput, (HolderLookup.Provider)registriesProvider, (DynamicOps<JsonElement>)dynamicOps, (RegistrySupplier.RegistryInfo)registryData, this.registries)).toArray(CompletableFuture[]::new);
            this.registries.releaseLock();
            return CompletableFuture.allOf(futures);
        }));
    }

    private <T> CompletableFuture<?> serializeRegistry(CachedOutput cachedOutput, HolderLookup.Provider registryAccess, DynamicOps<JsonElement> dynamicOps, RegistrySupplier.RegistryInfo<T> registryData, RegistrySupplier registries) {
        try {
            registries.MAIN_LOCK.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        List<Holder<T>> elements = registryData.allElements(registryAccess);
        HolderLookup.RegistryLookup registry = registryAccess.m_255025_(registryData.key());
        this.LOGGER.info("Serializing " + elements.size() + "/" + registry.m_214062_().count() + " elements from " + registryData.data.f_243794_());
        registries.MAIN_LOCK.release();
        if (!elements.isEmpty()) {
            PackOutput.PathProvider pathProvider = this.output.m_245269_(PackOutput.Target.DATA_PACK, registryData.key().m_135782_().m_135815_());
            return CompletableFuture.allOf((CompletableFuture[])elements.stream().map(entry -> this.serializeElements(pathProvider.m_245731_(((ResourceKey)entry.m_203543_().orElseThrow()).m_135782_()), cachedOutput, dynamicOps, (Encoder)registryData.elementCodec(), (Object)entry.m_203334_())).toArray(CompletableFuture[]::new));
        }
        return CompletableFuture.completedFuture(null);
    }

    private <E> CompletableFuture<?> serializeElements(Path path, CachedOutput cachedOutput, DynamicOps<JsonElement> dynamicOps, Encoder<E> encoder, E object) {
        Optional optional = encoder.encodeStart(dynamicOps, object).resultOrPartial(string -> this.LOGGER.error("Couldn't serialize element {}: {}", path, string));
        if (optional.isPresent()) {
            return DataProvider.m_253162_((CachedOutput)cachedOutput, (JsonElement)((JsonElement)optional.get()), (Path)path);
        }
        return CompletableFuture.completedFuture(null);
    }

    public void buildRegistry(RegistrySetBuilder registryBuilder) {
        this.registries.allRegistries.stream().filter(nfo -> nfo.registryBootstrap != null).forEach(nfo -> {});
    }

    public String m_6055_() {
        return "Registries";
    }
}

