/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.bonemeal;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public interface BonemealGrassLike
extends BonemealableBlock {
    public BlockState getGrowableCoverState();

    public Block getHostBlock();

    public Holder<PlacedFeature> getCoverFeature();

    public List<ConfiguredFeature<?, ?>> getFlowerFeatures();

    default public boolean canGrowFlower(RandomSource random) {
        return random.m_188503_(8) == 0;
    }

    default public boolean canGrowCover(RandomSource random) {
        return random.m_188503_(10) == 0;
    }

    default public boolean isValidBonemealTarget(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, boolean bl) {
        return blockGetter.m_8055_(blockPos.m_7494_()).m_60795_();
    }

    default public boolean m_214167_(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    default public void m_214148_(ServerLevel serverLevel, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos above = pos.m_7494_();
        BlockState growableState = this.getGrowableCoverState();
        block0: for (int bonemealAttempt = 0; bonemealAttempt < 128; ++bonemealAttempt) {
            Holder boneFeature;
            BlockPos currentPos = above;
            for (int j = 0; j < bonemealAttempt / 16; ++j) {
                if (!serverLevel.m_8055_((currentPos = currentPos.m_7918_(random.m_188503_(3) - 1, (random.m_188503_(3) - 1) * random.m_188503_(3) / 2, random.m_188503_(3) - 1)).m_7495_()).m_60713_(this.getHostBlock()) || serverLevel.m_8055_(currentPos).m_60838_((BlockGetter)serverLevel, currentPos)) continue block0;
            }
            BlockState currentState = serverLevel.m_8055_(currentPos);
            if (currentState.m_60713_(growableState.m_60734_()) && this.canGrowCover(random)) {
                ((BonemealableBlock)growableState.m_60734_()).m_214148_(serverLevel, random, currentPos, currentState);
            }
            if (!currentState.m_60795_()) continue;
            if (this.canGrowFlower(random)) {
                List<ConfiguredFeature<?, ?>> list = this.getFlowerFeatures();
                if (list.isEmpty()) continue;
                boneFeature = ((RandomPatchConfiguration)list.get(0).f_65378_()).f_191304_();
            } else {
                boneFeature = this.getCoverFeature();
            }
            ((PlacedFeature)boneFeature.m_203334_()).m_226357_((WorldGenLevel)serverLevel, serverLevel.m_7726_().m_8481_(), random, currentPos);
        }
    }
}

