/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.biomes;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.biome.OverworldBiomes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeContainer;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeSettings;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.levelgen.biomes.UnboundBCLBiome;
import org.betterx.bclib.api.v2.levelgen.structures.BCLStructure;
import org.betterx.bclib.api.v2.levelgen.surface.SurfaceRuleBuilder;
import org.betterx.bclib.api.v3.levelgen.features.BCLFeature;
import org.betterx.bclib.entity.BCLEntityWrapper;
import org.betterx.bclib.mixin.common.BiomeGenerationSettingsAccessor;
import org.betterx.bclib.util.CollectionsUtil;
import org.betterx.bclib.util.Pair;
import org.betterx.ui.ColorUtil;
import org.betterx.worlds.together.surfaceRules.SurfaceRuleRegistry;
import org.betterx.worlds.together.tag.v3.TagManager;

public class BCLBiomeBuilder {
    static final ConcurrentLinkedQueue<UnboundBCLBiome<?>> UNBOUND_BIOMES = new ConcurrentLinkedQueue();
    public static int DEFAULT_NETHER_WATER_COLOR;
    public static int DEFAULT_END_WATER_COLOR;
    public static int DEFAULT_NETHER_WATER_FOG_COLOR;
    public static int DEFAULT_END_WATER_FOG_COLOR;
    public static int DEFAULT_END_FOG_COLOR;
    public static int DEFAULT_END_SKY_COLOR;
    public static float DEFAULT_NETHER_TEMPERATURE;
    public static float DEFAULT_END_TEMPERATURE;
    public static float DEFAULT_NETHER_WETNESS;
    public static float DEFAULT_END_WETNESS;
    private static final SurfaceRules.ConditionSource SURFACE_NOISE;
    private final List<FeatureSupplier> featureSupliers = new LinkedList<FeatureSupplier>();
    private final List<Pair<GenerationStep.Carving, Holder<? extends ConfiguredWorldCarver<?>>>> carvers = new ArrayList(1);
    private BiomeGenerationSettings.Builder generationSettings;
    private BiomeSpecialEffects.Builder effectsBuilder;
    private MobSpawnSettings.Builder spawnSettings;
    private SurfaceRules.RuleSource surfaceRule;
    private boolean hasPrecipitation;
    private final ResourceLocation biomeID;
    private final Set<TagKey<Biome>> tags = Sets.newHashSet();
    private final List<Climate.ParameterPoint> parameters = Lists.newArrayList();
    private float temperature;
    private float fogDensity;
    private float genChance;
    private float downfall;
    private float height;
    private int edgeSize;
    private BCLBiome edge;
    private BCLBiome parent;
    private boolean vertical;
    private BiomeAPI.BiomeType biomeType;

    public static int calculateSkyColor(float temperature) {
        return OverworldBiomes.m_194843_((float)temperature);
    }

    BCLBiomeBuilder(ResourceLocation biomeID) {
        this.biomeID = biomeID;
        this.hasPrecipitation = false;
        this.generationSettings = null;
        this.effectsBuilder = null;
        this.spawnSettings = null;
        this.temperature = 1.0f;
        this.fogDensity = 1.0f;
        this.edgeSize = 0;
        this.downfall = 1.0f;
        this.genChance = 1.0f;
        this.height = 0.1f;
        this.vertical = false;
        this.edge = null;
        this.parent = null;
        this.biomeType = null;
    }

    public static BCLBiomeBuilder start(ResourceLocation biomeID) {
        return new BCLBiomeBuilder(biomeID);
    }

    public BCLBiomeBuilder addNetherClimateParamater(float temperature, float humidity, float offset) {
        this.parameters.add(Climate.m_186788_((float)temperature, (float)humidity, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)offset));
        return this;
    }

    public BCLBiomeBuilder addNetherClimateParamater(float temperature, float humidity) {
        return this.addNetherClimateParamater(temperature, humidity, 0.0f);
    }

    public BCLBiomeBuilder parentBiome(BCLBiome parent) {
        this.parent = parent;
        return this;
    }

    public BCLBiomeBuilder type(BiomeAPI.BiomeType type) {
        this.biomeType = type;
        return this;
    }

    @Deprecated(forRemoval=true)
    public BCLBiomeBuilder precipitation(Biome.Precipitation precipitation) {
        return this.hasPrecipitation(precipitation != Biome.Precipitation.NONE);
    }

    public BCLBiomeBuilder hasPrecipitation(boolean precipitation) {
        this.hasPrecipitation = precipitation;
        return this;
    }

    public BCLBiomeBuilder temperature(float temperature) {
        this.temperature = temperature;
        return this;
    }

    public BCLBiomeBuilder wetness(float wetness) {
        this.downfall = wetness;
        return this;
    }

    public <M extends Mob> BCLBiomeBuilder spawn(EntityType<M> entityType, int weight, int minGroupCount, int maxGroupCount) {
        this.getSpawns().m_48376_(entityType.m_20674_(), new MobSpawnSettings.SpawnerData(entityType, weight, minGroupCount, maxGroupCount));
        return this;
    }

    public <M extends Mob> BCLBiomeBuilder spawn(BCLEntityWrapper<M> wrapper, int weight, int minGroupCount, int maxGroupCount) {
        if (wrapper.canSpawn()) {
            return this.spawn(wrapper.type(), weight, minGroupCount, maxGroupCount);
        }
        return this;
    }

    public BCLBiomeBuilder particles(ParticleOptions particle, float probability) {
        this.getEffects().m_48029_(new AmbientParticleSettings(particle, probability));
        return this;
    }

    public BCLBiomeBuilder skyColor(int color) {
        this.getEffects().m_48040_(color);
        return this;
    }

    public BCLBiomeBuilder skyColor(int red, int green, int blue) {
        red = Mth.m_14045_((int)red, (int)0, (int)255);
        green = Mth.m_14045_((int)green, (int)0, (int)255);
        blue = Mth.m_14045_((int)blue, (int)0, (int)255);
        return this.skyColor(ColorUtil.color(red, green, blue));
    }

    public BCLBiomeBuilder fogColor(int color) {
        this.getEffects().m_48019_(color);
        return this;
    }

    public BCLBiomeBuilder fogColor(int red, int green, int blue) {
        red = Mth.m_14045_((int)red, (int)0, (int)255);
        green = Mth.m_14045_((int)green, (int)0, (int)255);
        blue = Mth.m_14045_((int)blue, (int)0, (int)255);
        return this.fogColor(ColorUtil.color(red, green, blue));
    }

    public BCLBiomeBuilder fogDensity(float density) {
        this.fogDensity = density;
        return this;
    }

    public BCLBiomeBuilder genChance(float genChance) {
        this.genChance = genChance;
        return this;
    }

    public BCLBiomeBuilder edgeSize(int edgeSize) {
        this.edgeSize = edgeSize;
        return this;
    }

    public BCLBiomeBuilder edge(BCLBiome edge) {
        this.edge = edge;
        return this;
    }

    public BCLBiomeBuilder edge(BCLBiome edge, int edgeSize) {
        this.edge(edge);
        this.edgeSize(edgeSize);
        return this;
    }

    public BCLBiomeBuilder waterColor(int color) {
        this.getEffects().m_48034_(color);
        return this;
    }

    public BCLBiomeBuilder waterColor(int red, int green, int blue) {
        red = Mth.m_14045_((int)red, (int)0, (int)255);
        green = Mth.m_14045_((int)green, (int)0, (int)255);
        blue = Mth.m_14045_((int)blue, (int)0, (int)255);
        return this.waterColor(ColorUtil.color(red, green, blue));
    }

    public BCLBiomeBuilder waterFogColor(int color) {
        this.getEffects().m_48037_(color);
        return this;
    }

    public BCLBiomeBuilder waterFogColor(int red, int green, int blue) {
        red = Mth.m_14045_((int)red, (int)0, (int)255);
        green = Mth.m_14045_((int)green, (int)0, (int)255);
        blue = Mth.m_14045_((int)blue, (int)0, (int)255);
        return this.waterFogColor(ColorUtil.color(red, green, blue));
    }

    public BCLBiomeBuilder waterAndFogColor(int color) {
        return this.waterColor(color).waterFogColor(color);
    }

    public BCLBiomeBuilder waterAndFogColor(int red, int green, int blue) {
        red = Mth.m_14045_((int)red, (int)0, (int)255);
        green = Mth.m_14045_((int)green, (int)0, (int)255);
        blue = Mth.m_14045_((int)blue, (int)0, (int)255);
        return this.waterAndFogColor(ColorUtil.color(red, green, blue));
    }

    public BCLBiomeBuilder grassColor(int color) {
        this.getEffects().m_48045_(color);
        return this;
    }

    public BCLBiomeBuilder grassColor(int red, int green, int blue) {
        red = Mth.m_14045_((int)red, (int)0, (int)255);
        green = Mth.m_14045_((int)green, (int)0, (int)255);
        blue = Mth.m_14045_((int)blue, (int)0, (int)255);
        return this.grassColor(ColorUtil.color(red, green, blue));
    }

    public BCLBiomeBuilder foliageColor(int color) {
        this.getEffects().m_48043_(color);
        return this;
    }

    public BCLBiomeBuilder foliageColor(int red, int green, int blue) {
        red = Mth.m_14045_((int)red, (int)0, (int)255);
        green = Mth.m_14045_((int)green, (int)0, (int)255);
        blue = Mth.m_14045_((int)blue, (int)0, (int)255);
        return this.foliageColor(ColorUtil.color(red, green, blue));
    }

    public BCLBiomeBuilder plantsColor(int color) {
        return this.grassColor(color).foliageColor(color);
    }

    public BCLBiomeBuilder plantsColor(int red, int green, int blue) {
        red = Mth.m_14045_((int)red, (int)0, (int)255);
        green = Mth.m_14045_((int)green, (int)0, (int)255);
        blue = Mth.m_14045_((int)blue, (int)0, (int)255);
        return this.plantsColor(ColorUtil.color(red, green, blue));
    }

    public BCLBiomeBuilder music(Music music) {
        this.getEffects().m_48021_(music);
        return this;
    }

    public BCLBiomeBuilder music(Holder<SoundEvent> music) {
        return this.music(new Music(music, 600, 2400, true));
    }

    public BCLBiomeBuilder loop(Holder<SoundEvent> loopSound) {
        this.getEffects().m_48023_(loopSound);
        return this;
    }

    public BCLBiomeBuilder mood(Holder<SoundEvent> mood, int tickDelay, int blockSearchExtent, float soundPositionOffset) {
        this.getEffects().m_48027_(new AmbientMoodSettings(mood, tickDelay, blockSearchExtent, (double)soundPositionOffset));
        return this;
    }

    public BCLBiomeBuilder mood(Holder<SoundEvent> mood) {
        return this.mood(mood, 6000, 8, 2.0f);
    }

    public BCLBiomeBuilder additions(Holder<SoundEvent> additions, float intensity) {
        this.getEffects().m_48025_(new AmbientAdditionsSettings(additions, (double)intensity));
        return this;
    }

    public BCLBiomeBuilder additions(Holder<SoundEvent> additions) {
        return this.additions(additions, 0.0111f);
    }

    public BCLBiomeBuilder feature(GenerationStep.Decoration decoration, Holder<PlacedFeature> feature) {
        this.featureSupliers.add(gen -> gen.m_255419_(decoration, feature));
        return this;
    }

    public BCLBiomeBuilder feature(GenerationStep.Decoration decoration, ResourceKey<PlacedFeature> feature) {
        this.featureSupliers.add(gen -> gen.m_255155_(decoration, feature));
        return this;
    }

    public BCLBiomeBuilder defaultMushrooms() {
        return this.feature(BiomeDefaultFeatures::m_126730_);
    }

    public BCLBiomeBuilder netherDefaultOres() {
        return this.feature(BiomeDefaultFeatures::m_126773_);
    }

    public BCLBiomeBuilder feature(Consumer<BiomeGenerationSettings.Builder> featureAdd) {
        this.featureSupliers.add(gen -> featureAdd.accept((BiomeGenerationSettings.Builder)gen));
        return this;
    }

    public BCLBiomeBuilder feature(BCLFeature feature) {
        return this.feature(feature.decoration, feature.placedFeature);
    }

    public BCLBiomeBuilder structure(TagKey<Biome> structureTag) {
        this.tags.add(structureTag);
        return this;
    }

    public BCLBiomeBuilder structure(BCLStructure structure) {
        structure.addInternalBiome(this.biomeID);
        return this.structure(structure.biomeTag);
    }

    public BCLBiomeBuilder carver(GenerationStep.Carving step, Holder<ConfiguredWorldCarver<?>> carver) {
        Optional oKey = carver.m_203543_();
        if (oKey.isPresent()) {
            return this.carver(step, (ResourceKey)oKey.get());
        }
        return this;
    }

    public BCLBiomeBuilder carver(GenerationStep.Carving step, ResourceKey<ConfiguredWorldCarver<?>> carverKey) {
        BiomeModifications.addCarver(ctx -> ctx.getBiomeKey().m_135782_().equals((Object)this.biomeID), (GenerationStep.Carving)step, carverKey);
        return this;
    }

    public BCLBiomeBuilder surface(Block surfaceBlock) {
        return this.surface(surfaceBlock.m_49966_());
    }

    public BCLBiomeBuilder surface(BlockState surfaceBlock) {
        return this.surface(SurfaceRuleBuilder.start().surface(surfaceBlock).build());
    }

    public BCLBiomeBuilder surface(Block surfaceBlock, Block subterrainBlock, int depth) {
        return this.surface(SurfaceRuleBuilder.start().surface(surfaceBlock.m_49966_()).subsurface(subterrainBlock.m_49966_(), depth).build());
    }

    public BCLBiomeBuilder surface(SurfaceRules.RuleSource newSurfaceRule) {
        this.surfaceRule = newSurfaceRule;
        return this;
    }

    public BCLBiomeBuilder intendedType(BiomeAPI.BiomeType type) {
        this.biomeType = type;
        return this;
    }

    public BCLBiomeBuilder endLandBiome() {
        return this.intendedType(BiomeAPI.BiomeType.BCL_END_LAND);
    }

    public BCLBiomeBuilder endVoidBiome() {
        return this.intendedType(BiomeAPI.BiomeType.BCL_END_VOID);
    }

    public BCLBiomeBuilder endBarrensBiome() {
        return this.intendedType(BiomeAPI.BiomeType.BCL_END_BARRENS);
    }

    public BCLBiomeBuilder endCenterBiome() {
        return this.intendedType(BiomeAPI.BiomeType.BCL_END_CENTER);
    }

    public BCLBiomeBuilder netherBiome() {
        return this.intendedType(BiomeAPI.BiomeType.BCL_NETHER);
    }

    public BCLBiomeBuilder tag(TagKey<Biome> ... tag) {
        for (TagKey<Biome> t : tag) {
            this.tags.add(t);
        }
        return this;
    }

    public BCLBiomeBuilder terrainHeight(float height) {
        this.height = height;
        return this;
    }

    public BCLBiomeBuilder vertical() {
        this.vertical = true;
        return this;
    }

    private static BiomeGenerationSettings fixGenerationSettings(BiomeGenerationSettings settings) {
        if (settings instanceof BiomeGenerationSettingsAccessor) {
            BiomeGenerationSettingsAccessor acc = (BiomeGenerationSettingsAccessor)settings;
            Map<GenerationStep.Carving, HolderSet<ConfiguredWorldCarver<?>>> carvers = CollectionsUtil.getMutable(acc.bclib_getCarvers());
            for (GenerationStep.Carving step : GenerationStep.Carving.values()) {
                carvers.computeIfAbsent(step, __ -> HolderSet.m_205800_((List)Lists.newArrayList()));
            }
            acc.bclib_setCarvers(carvers);
        }
        return settings;
    }

    private BiomeSpecialEffects.Builder getEffects() {
        if (this.effectsBuilder == null) {
            this.effectsBuilder = new BiomeSpecialEffects.Builder();
        }
        return this.effectsBuilder;
    }

    private MobSpawnSettings.Builder getSpawns() {
        if (this.spawnSettings == null) {
            this.spawnSettings = new MobSpawnSettings.Builder();
        }
        return this.spawnSettings;
    }

    private BiomeGenerationSettings.Builder getGeneration(BootstapContext<Biome> bootstrapContext) {
        if (this.generationSettings == null) {
            this.generationSettings = new BiomeGenerationSettings.Builder(bootstrapContext.m_255420_(Registries.f_256988_), bootstrapContext.m_255420_(Registries.f_257003_));
        }
        return this.generationSettings;
    }

    public BCLBiomeContainer<BCLBiome> build() {
        return this.build(BCLBiome::new);
    }

    public <T extends BCLBiome> BCLBiomeContainer<T> build(BiomeSupplier<T> biomeConstructor) {
        Object settings = ((BCLBiomeSettings.Builder)((BCLBiomeSettings.Builder)((BCLBiomeSettings.Builder)((BCLBiomeSettings.Builder)((BCLBiomeSettings.Builder)BCLBiomeSettings.createBCL().setTerrainHeight(this.height)).setFogDensity(this.fogDensity)).setGenChance(this.genChance)).setEdgeSize(this.edgeSize)).setVertical(this.vertical)).build();
        BCLBiome bclBiome = (BCLBiome)biomeConstructor.apply(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)this.biomeID), settings);
        this.tags.forEach(tagKey -> TagManager.BIOMES.add((TagKey<Biome>)tagKey, bclBiome.getBiomeKey()));
        SurfaceRuleRegistry.registerRule(this.biomeID, this.surfaceRule, this.biomeID);
        bclBiome.addClimateParameters(this.parameters);
        if (this.biomeType != null) {
            bclBiome._setIntendedType(this.biomeType);
        }
        Biome.BiomeBuilder builder = new Biome.BiomeBuilder().m_264558_(this.hasPrecipitation).m_47609_(this.temperature).m_47611_(this.downfall);
        builder.m_47605_(this.getSpawns().m_48381_());
        builder.m_47603_(this.getEffects().m_48018_());
        if (this.edge != null) {
            bclBiome._setEdge(this.edge);
        }
        UnboundBCLBiome<BCLBiome> unbound = new UnboundBCLBiome<BCLBiome>(bclBiome, this.parent, ctx -> {
            BiomeGenerationSettings.Builder genBuilder = this.getGeneration((BootstapContext<Biome>)ctx);
            this.featureSupliers.forEach(s -> s.accept(genBuilder));
            return builder.m_47601_(BCLBiomeBuilder.fixGenerationSettings(genBuilder.m_255380_())).m_47592_();
        });
        UNBOUND_BIOMES.add(unbound);
        return unbound;
    }

    public static void registerUnbound(BootstapContext<Biome> context) {
        UNBOUND_BIOMES.forEach((Consumer<UnboundBCLBiome<?>>)((Consumer<UnboundBCLBiome>)u -> u.register(context)));
        UNBOUND_BIOMES.clear();
    }

    static {
        DEFAULT_END_WATER_COLOR = DEFAULT_NETHER_WATER_COLOR = 4159204;
        DEFAULT_END_WATER_FOG_COLOR = DEFAULT_NETHER_WATER_FOG_COLOR = 329011;
        DEFAULT_END_FOG_COLOR = 0xA080A0;
        DEFAULT_END_SKY_COLOR = 0;
        DEFAULT_NETHER_TEMPERATURE = 2.0f;
        DEFAULT_END_TEMPERATURE = 0.5f;
        DEFAULT_NETHER_WETNESS = 0.0f;
        DEFAULT_END_WETNESS = 0.5f;
        SURFACE_NOISE = SurfaceRules.m_189409_((ResourceKey)Noises.f_189272_, (double)-0.012);
    }

    @FunctionalInterface
    private static interface FeatureSupplier
    extends Consumer<BiomeGenerationSettings.Builder> {
    }

    @FunctionalInterface
    public static interface BiomeSupplier<T>
    extends BiFunction<ResourceKey<Biome>, BCLBiomeSettings, T> {
    }

    @FunctionalInterface
    static interface BuildCompletion
    extends Function<BootstapContext<Biome>, Biome> {
    }
}

