/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.generator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.jetbrains.annotations.ApiStatus;

public class TheEndBiomesHelper {
    @ApiStatus.Internal
    private static Map<BiomeAPI.BiomeType, Set<ResourceKey<Biome>>> END_BIOMES = new HashMap<BiomeAPI.BiomeType, Set<ResourceKey<Biome>>>();

    @ApiStatus.Internal
    public static void add(BiomeAPI.BiomeType type, ResourceKey<Biome> biome) {
        if (biome == null) {
            return;
        }
        END_BIOMES.computeIfAbsent(type, t -> new HashSet()).add(biome);
    }

    private static boolean has(BiomeAPI.BiomeType type, ResourceKey<Biome> biome) {
        if (biome == null) {
            return false;
        }
        Set<ResourceKey<Biome>> set = END_BIOMES.get(type);
        if (set == null) {
            return false;
        }
        return set.contains(biome);
    }

    public static boolean canGenerateAsMainIslandBiome(ResourceKey<Biome> biome) {
        return TheEndBiomesHelper.has(BiomeAPI.BiomeType.END_CENTER, biome);
    }

    public static boolean canGenerateAsSmallIslandsBiome(ResourceKey<Biome> biome) {
        return TheEndBiomesHelper.has(BiomeAPI.BiomeType.END_VOID, biome);
    }

    public static boolean canGenerateAsHighlandsBiome(ResourceKey<Biome> biome) {
        return TheEndBiomesHelper.has(BiomeAPI.BiomeType.END_LAND, biome);
    }

    public static boolean canGenerateAsEndMidlands(ResourceKey<Biome> biome) {
        return false;
    }

    public static boolean canGenerateAsEndBarrens(ResourceKey<Biome> biome) {
        return TheEndBiomesHelper.has(BiomeAPI.BiomeType.END_BARRENS, biome);
    }

    public static boolean canGenerateInEnd(ResourceKey<Biome> biome) {
        return TheEndBiomesHelper.canGenerateAsHighlandsBiome(biome) || TheEndBiomesHelper.canGenerateAsEndBarrens(biome) || TheEndBiomesHelper.canGenerateAsEndMidlands(biome) || TheEndBiomesHelper.canGenerateAsSmallIslandsBiome(biome) || TheEndBiomesHelper.canGenerateAsMainIslandBiome(biome);
    }
}

