/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.dataexchange.handler.autosync;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.loader.api.metadata.ModEnvironment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.dataexchange.DataExchangeAPI;
import org.betterx.bclib.api.v2.dataexchange.DataHandler;
import org.betterx.bclib.api.v2.dataexchange.DataHandlerDescriptor;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.AutoFileSyncEntry;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.AutoSync;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.AutoSyncID;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.ChunkerProgress;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.FileContentWrapper;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.RequestFiles;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.SendFiles;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.SyncFolderDescriptor;
import org.betterx.bclib.client.gui.screens.ModListScreen;
import org.betterx.bclib.client.gui.screens.ProgressScreen;
import org.betterx.bclib.client.gui.screens.SyncFilesScreen;
import org.betterx.bclib.client.gui.screens.WarnBCLibVersionMismatch;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.config.ServerConfig;
import org.betterx.worlds.together.util.ModUtil;
import org.betterx.worlds.together.util.PathUtil;

public class HelloClient
extends DataHandler.FromServer {
    public static final DataHandlerDescriptor DESCRIPTOR = new DataHandlerDescriptor(new ResourceLocation("bclib", "hello_client"), HelloClient::new, false, false);
    String bclibVersion = "0.0.0";
    IServerModMap modVersion = new ServerModMap();
    List<AutoSync.AutoSyncTriple> autoSyncedFiles = null;
    List<SyncFolderDescriptor> autoSynFolders = null;
    boolean serverPublishedModInfo = false;

    public HelloClient() {
        super(HelloClient.DESCRIPTOR.IDENTIFIER);
    }

    static String getBCLibVersion() {
        return ModUtil.getModVersion("bclib");
    }

    @Override
    protected boolean prepareDataOnServer() {
        if (!Configs.SERVER_CONFIG.isAllowingAutoSync()) {
            BCLib.LOGGER.info("Auto-Sync was disabled on the server.");
            return false;
        }
        AutoSync.loadSyncFolder();
        return true;
    }

    @Override
    protected void serializeDataOnServer(FriendlyByteBuf buf) {
        String vbclib = HelloClient.getBCLibVersion();
        BCLib.LOGGER.info("Sending Hello to Client. (server=" + vbclib + ")");
        buf.writeInt(ModUtil.convertModVersion(vbclib));
        if (Configs.SERVER_CONFIG.isOfferingMods() || Configs.SERVER_CONFIG.isOfferingInfosForMods()) {
            List<String> mods = DataExchangeAPI.registeredMods();
            List<String> inmods = mods;
            if (Configs.SERVER_CONFIG.isOfferingAllMods() || Configs.SERVER_CONFIG.isOfferingInfosForMods()) {
                mods = new ArrayList<String>(inmods.size());
                mods.addAll(inmods);
                mods.addAll(ModUtil.getMods().entrySet().stream().filter(entry -> ((ModUtil.ModInfo)entry.getValue()).metadata.getEnvironment() != ModEnvironment.SERVER && !inmods.contains(entry.getKey())).map(entry -> (String)entry.getKey()).collect(Collectors.toList()));
            }
            mods = mods.stream().filter(entry -> !Configs.SERVER_CONFIG.get(ServerConfig.EXCLUDED_MODS).contains(entry)).collect(Collectors.toList());
            buf.writeInt(mods.size());
            for (String modID : mods) {
                String ver = ModUtil.getModVersion(modID);
                int size = 0;
                ModUtil.ModInfo mi = ModUtil.getModInfo(modID);
                if (mi != null) {
                    try {
                        size = (int)Files.size(mi.jarPath);
                    }
                    catch (IOException e2) {
                        BCLib.LOGGER.error("Unable to get File Size: " + e2.getMessage());
                    }
                }
                HelloClient.writeString(buf, modID);
                buf.writeInt(ModUtil.convertModVersion(ver));
                buf.writeInt(size);
                boolean canDownload = size > 0 && Configs.SERVER_CONFIG.isOfferingMods() && (Configs.SERVER_CONFIG.isOfferingAllMods() || inmods.contains(modID));
                buf.writeBoolean(canDownload);
                if (!Configs.MAIN_CONFIG.verboseLogging()) continue;
                BCLib.LOGGER.info("\t- Listing Mod " + modID + " v" + ver + " (size: " + PathUtil.humanReadableFileSize(size) + ", download=" + canDownload + ")");
            }
        } else {
            BCLib.LOGGER.info("Server will not list Mods.");
            buf.writeInt(0);
        }
        if (Configs.SERVER_CONFIG.isOfferingFiles() || Configs.SERVER_CONFIG.isOfferingConfigs()) {
            List existingAutoSyncFiles = AutoSync.getAutoSyncFiles().stream().filter(e -> e.fileName.exists()).filter(e -> e.isConfigFile() && Configs.SERVER_CONFIG.isOfferingConfigs() || e instanceof AutoFileSyncEntry.ForDirectFileRequest && Configs.SERVER_CONFIG.isOfferingFiles()).collect(Collectors.toList());
            buf.writeInt(existingAutoSyncFiles.size());
            for (AutoFileSyncEntry entry2 : existingAutoSyncFiles) {
                entry2.serialize(buf);
                if (!Configs.MAIN_CONFIG.verboseLogging()) continue;
                BCLib.LOGGER.info("\t- Offering " + (entry2.isConfigFile() ? "Config " : "File ") + entry2);
            }
        } else {
            BCLib.LOGGER.info("Server will neither offer Files nor Configs.");
            buf.writeInt(0);
        }
        if (Configs.SERVER_CONFIG.isOfferingFiles()) {
            buf.writeInt(AutoSync.syncFolderDescriptions.size());
            AutoSync.syncFolderDescriptions.forEach(desc -> {
                if (Configs.MAIN_CONFIG.verboseLogging()) {
                    BCLib.LOGGER.info("\t- Offering Folder " + desc.localFolder + " (allowDelete=" + desc.removeAdditionalFiles + ")");
                }
                desc.serialize(buf);
            });
        } else {
            BCLib.LOGGER.info("Server will not offer Sync Folders.");
            buf.writeInt(0);
        }
        buf.writeBoolean(Configs.SERVER_CONFIG.isOfferingInfosForMods());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void deserializeIncomingDataOnClient(FriendlyByteBuf buf, PacketSender responseSender) {
        int i;
        this.bclibVersion = ModUtil.convertModVersion(buf.readInt());
        this.modVersion = new ServerModMap();
        int count = buf.readInt();
        for (i = 0; i < count; ++i) {
            String id = HelloClient.readString(buf);
            String version = ModUtil.convertModVersion(buf.readInt());
            int size = buf.readInt();
            boolean canDownload = buf.readBoolean();
            this.modVersion.put(id, new OfferedModInfo(version, size, canDownload));
        }
        count = buf.readInt();
        this.autoSyncedFiles = new ArrayList<AutoSync.AutoSyncTriple>(count);
        for (i = 0; i < count; ++i) {
            AutoSync.AutoSyncTriple t = AutoFileSyncEntry.deserializeAndMatch(buf);
            this.autoSyncedFiles.add(t);
        }
        this.autoSynFolders = new ArrayList<SyncFolderDescriptor>(1);
        int folderCount = buf.readInt();
        for (int i2 = 0; i2 < folderCount; ++i2) {
            SyncFolderDescriptor desc = SyncFolderDescriptor.deserialize(buf);
            this.autoSynFolders.add(desc);
        }
        this.serverPublishedModInfo = buf.readBoolean();
    }

    @Environment(value=EnvType.CLIENT)
    private void processAutoSyncFolder(List<AutoSyncID> filesToRequest, List<AutoSyncID.ForDirectFileRequest> filesToRemove) {
        if (!Configs.CLIENT_CONFIG.isAcceptingFiles()) {
            return;
        }
        if (this.autoSynFolders.size() > 0 && Configs.MAIN_CONFIG.verboseLogging()) {
            BCLib.LOGGER.info("Folders offered by Server:");
        }
        this.autoSynFolders.forEach(desc -> {
            SyncFolderDescriptor localDescriptor = AutoSync.getSyncFolderDescriptor(desc.folderID);
            if (localDescriptor != null) {
                if (Configs.MAIN_CONFIG.verboseLogging()) {
                    BCLib.LOGGER.info("\t- " + desc.folderID + " (" + desc.localFolder + ", allowRemove=" + desc.removeAdditionalFiles + ")");
                }
                localDescriptor.invalidateCache();
                desc.relativeFilesStream().filter(desc::discardChildElements).forEach(subFile -> {
                    if (Configs.MAIN_CONFIG.verboseLogging()) {
                        BCLib.LOGGER.warning("\t   * " + subFile.relPath + " (REJECTED)", new Object[0]);
                    }
                });
                if (desc.removeAdditionalFiles) {
                    List<AutoSyncID.ForDirectFileRequest> additionalFiles = localDescriptor.relativeFilesStream().filter(subFile -> !desc.hasRelativeFile((SyncFolderDescriptor.SubFile)subFile)).map(desc::mapAbsolute).filter(desc::acceptChildElements).map(absPath -> new AutoSyncID.ForDirectFileRequest(desc.folderID, absPath.toFile())).collect(Collectors.toList());
                    if (Configs.MAIN_CONFIG.verboseLogging()) {
                        additionalFiles.forEach(aid -> BCLib.LOGGER.info("\t   * " + desc.localFolder.relativize(aid.relFile.toPath()) + " (missing on server)"));
                    }
                    filesToRemove.addAll(additionalFiles);
                }
                desc.relativeFilesStream().filter(desc::acceptChildElements).forEach(subFile -> {
                    SyncFolderDescriptor.SubFile localSubFile = localDescriptor.getLocalSubFile(subFile.relPath);
                    if (localSubFile != null) {
                        if (!localSubFile.hash.equals(subFile.hash)) {
                            if (Configs.MAIN_CONFIG.verboseLogging()) {
                                BCLib.LOGGER.info("\t   * " + subFile.relPath + " (changed)");
                            }
                            filesToRequest.add(new AutoSyncID.ForDirectFileRequest(desc.folderID, new File(subFile.relPath)));
                        } else if (Configs.MAIN_CONFIG.verboseLogging()) {
                            BCLib.LOGGER.info("\t   * " + subFile.relPath);
                        }
                    } else {
                        if (Configs.MAIN_CONFIG.verboseLogging()) {
                            BCLib.LOGGER.info("\t   * " + subFile.relPath + " (missing on client)");
                        }
                        filesToRequest.add(new AutoSyncID.ForDirectFileRequest(desc.folderID, new File(subFile.relPath)));
                    }
                });
                localDescriptor.invalidateCache();
            } else if (Configs.MAIN_CONFIG.verboseLogging()) {
                BCLib.LOGGER.info("\t- " + desc.folderID + " (Failed to find)");
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    private void processSingleFileSync(List<AutoSyncID> filesToRequest) {
        boolean debugHashes = Configs.CLIENT_CONFIG.shouldPrintDebugHashes();
        if (this.autoSyncedFiles.size() > 0 && Configs.MAIN_CONFIG.verboseLogging()) {
            BCLib.LOGGER.info("Files offered by Server:");
        }
        for (AutoSync.AutoSyncTriple e : this.autoSyncedFiles) {
            String actionString = "";
            FileContentWrapper contentWrapper = new FileContentWrapper(e.serverContent);
            if (e.localMatch == null) {
                actionString = "(unknown source -> omitting)";
            } else if (e.localMatch.needTransfer.test(e.localMatch.getFileHash(), e.serverHash, contentWrapper)) {
                actionString = "(prepare update)";
                if (contentWrapper.getRawContent() == null) {
                    filesToRequest.add(new AutoSyncID(e.serverHash.modID, e.serverHash.uniqueID));
                } else {
                    filesToRequest.add(new AutoSyncID.WithContentOverride(e.serverHash.modID, e.serverHash.uniqueID, contentWrapper, e.localMatch.fileName));
                }
            }
            if (!Configs.MAIN_CONFIG.verboseLogging()) continue;
            BCLib.LOGGER.info("\t- " + e + ": " + actionString);
            if (!debugHashes) continue;
            BCLib.LOGGER.info("\t  * " + e.serverHash + " (Server)");
            BCLib.LOGGER.info("\t  * " + e.localMatch.getFileHash() + " (Client)");
            BCLib.LOGGER.info("\t  * local Content " + (contentWrapper.getRawContent() == null));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void processModFileSync(List<AutoSyncID> filesToRequest, Set<String> mismatchingMods) {
        for (Map.Entry e : this.modVersion.entrySet()) {
            boolean requestMod;
            String localVersion = ModUtil.convertModVersion(ModUtil.convertModVersion(ModUtil.getModVersion((String)e.getKey())));
            OfferedModInfo serverInfo = (OfferedModInfo)e.getValue();
            ModUtil.ModInfo nfo = ModUtil.getModInfo((String)e.getKey());
            boolean clientOnly = nfo != null && nfo.metadata.getEnvironment() == ModEnvironment.CLIENT;
            boolean bl = requestMod = !clientOnly && !serverInfo.version.equals(localVersion) && serverInfo.size > 0 && serverInfo.canDownload;
            if (Configs.MAIN_CONFIG.verboseLogging()) {
                BCLib.LOGGER.info("\t- " + (String)e.getKey() + " (client=" + localVersion + ", server=" + serverInfo.version + ", size=" + PathUtil.humanReadableFileSize(serverInfo.size) + (requestMod ? ", requesting" : "") + (serverInfo.canDownload ? "" : ", not offered") + (clientOnly ? ", client only" : "") + ")");
            }
            if (requestMod) {
                filesToRequest.add(new AutoSyncID.ForModFileRequest((String)e.getKey(), serverInfo.version));
            }
            if (serverInfo.version.equals(localVersion)) continue;
            mismatchingMods.add((String)e.getKey());
        }
        mismatchingMods.addAll(ModListScreen.localMissing(this.modVersion));
        mismatchingMods.addAll(ModListScreen.serverMissing(this.modVersion));
    }

    @Override
    protected boolean isBlocking() {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void runOnClientGameThread(Minecraft client) {
        if (!Configs.CLIENT_CONFIG.isAllowingAutoSync()) {
            BCLib.LOGGER.info("Auto-Sync was disabled on the client.");
            return;
        }
        String localBclibVersion = HelloClient.getBCLibVersion();
        BCLib.LOGGER.info("Received Hello from Server. (client=" + localBclibVersion + ", server=" + this.bclibVersion + ")");
        if (ModUtil.convertModVersion(localBclibVersion) != ModUtil.convertModVersion(this.bclibVersion)) {
            this.showBCLibError(client);
            return;
        }
        ArrayList<AutoSyncID> filesToRequest = new ArrayList<AutoSyncID>(2);
        ArrayList<AutoSyncID.ForDirectFileRequest> filesToRemove = new ArrayList<AutoSyncID.ForDirectFileRequest>(2);
        HashSet<String> mismatchingMods = new HashSet<String>(2);
        this.processModFileSync(filesToRequest, mismatchingMods);
        this.processSingleFileSync(filesToRequest);
        this.processAutoSyncFolder(filesToRequest, filesToRemove);
        if ((filesToRequest.size() > 0 || filesToRemove.size() > 0) && (Configs.CLIENT_CONFIG.isAcceptingMods() || Configs.CLIENT_CONFIG.isAcceptingConfigs() || Configs.CLIENT_CONFIG.isAcceptingFiles())) {
            this.showSyncFilesScreen(client, filesToRequest, filesToRemove);
            return;
        }
        if (this.serverPublishedModInfo && mismatchingMods.size() > 0 && Configs.CLIENT_CONFIG.isShowingModInfo()) {
            client.m_91152_((Screen)new ModListScreen(client.f_91080_, (Component)Component.m_237115_((String)"title.bclib.modmissmatch"), (Component)Component.m_237115_((String)"message.bclib.modmissmatch"), CommonComponents.f_130659_, ModUtil.getMods(), this.modVersion));
            return;
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected void showBCLibError(Minecraft client) {
        BCLib.LOGGER.error("BCLib differs on client and server.");
        client.m_91152_((Screen)new WarnBCLibVersionMismatch(download -> {
            if (download) {
                this.requestBCLibDownload();
                this.onCloseSyncFilesScreen();
            } else {
                Minecraft.m_91087_().m_91152_(null);
            }
        }));
    }

    @Environment(value=EnvType.CLIENT)
    protected void showSyncFilesScreen(Minecraft client, List<AutoSyncID> files, List<AutoSyncID.ForDirectFileRequest> filesToRemove) {
        int configFiles = 0;
        int singleFiles = 0;
        int folderFiles = 0;
        int modFiles = 0;
        for (AutoSyncID aid : files) {
            if (aid.isConfigFile()) {
                ++configFiles;
                continue;
            }
            if (aid instanceof AutoSyncID.ForModFileRequest) {
                ++modFiles;
                continue;
            }
            if (aid instanceof AutoSyncID.ForDirectFileRequest) {
                ++folderFiles;
                continue;
            }
            ++singleFiles;
        }
        client.m_91152_((Screen)new SyncFilesScreen(modFiles, configFiles, singleFiles, folderFiles, filesToRemove.size(), this.modVersion, (downloadMods, downloadConfigs, downloadFiles, removeFiles) -> {
            if (downloadMods || downloadConfigs || downloadFiles) {
                BCLib.LOGGER.info("Updating local Files:");
                ArrayList localChanges = new ArrayList(files.toArray().length);
                ArrayList<AutoSyncID> requestFiles = new ArrayList<AutoSyncID>(files.toArray().length);
                files.forEach(aid -> {
                    if (aid.isConfigFile() && downloadConfigs) {
                        this.processOfferedFile((List<AutoSyncID>)requestFiles, (AutoSyncID)aid);
                    } else if (aid instanceof AutoSyncID.ForModFileRequest && downloadMods) {
                        this.processOfferedFile((List<AutoSyncID>)requestFiles, (AutoSyncID)aid);
                    } else if (downloadFiles) {
                        this.processOfferedFile((List<AutoSyncID>)requestFiles, (AutoSyncID)aid);
                    }
                });
                this.requestFileDownloads(requestFiles);
            }
            if (removeFiles) {
                filesToRemove.forEach(aid -> {
                    BCLib.LOGGER.info("\t- " + aid.relFile + " (removing)");
                    aid.relFile.delete();
                });
            }
            this.onCloseSyncFilesScreen();
        }));
    }

    @Environment(value=EnvType.CLIENT)
    private void onCloseSyncFilesScreen() {
        Minecraft.m_91087_().m_91152_((Screen)ChunkerProgress.getProgressScreen());
    }

    private void processOfferedFile(List<AutoSyncID> requestFiles, AutoSyncID aid) {
        if (aid instanceof AutoSyncID.WithContentOverride) {
            AutoSyncID.WithContentOverride aidc = (AutoSyncID.WithContentOverride)aid;
            BCLib.LOGGER.info("\t- " + aid + " (updating Content)");
            SendFiles.writeSyncedFile(aid, aidc.contentWrapper.getRawContent(), aidc.localFile);
        } else {
            requestFiles.add(aid);
            BCLib.LOGGER.info("\t- " + aid + " (requesting)");
        }
    }

    private void requestBCLibDownload() {
        BCLib.LOGGER.warning("Starting download of BCLib", new Object[0]);
        this.requestFileDownloads(List.of(new AutoSyncID.ForModFileRequest("bclib", this.bclibVersion)));
    }

    @Environment(value=EnvType.CLIENT)
    private void requestFileDownloads(List<AutoSyncID> files) {
        BCLib.LOGGER.info("Starting download of Files:" + files.size());
        ProgressScreen progress = new ProgressScreen(null, (Component)Component.m_237115_((String)"title.bclib.filesync.progress"), (Component)Component.m_237115_((String)"message.bclib.filesync.progress"));
        progress.m_6308_((Component)Component.m_237115_((String)"message.bclib.filesync.progress.stage.empty"));
        ChunkerProgress.setProgressScreen(progress);
        DataExchangeAPI.send(new RequestFiles(files));
    }

    public static class ServerModMap
    extends HashMap<String, OfferedModInfo>
    implements IServerModMap {
    }

    public static interface IServerModMap
    extends Map<String, OfferedModInfo> {
    }

    public record OfferedModInfo(String version, int size, boolean canDownload) {
    }
}

