/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.config;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import me.pepperbell.continuity.client.config.ContinuityConfig;
import me.pepperbell.continuity.client.config.Option;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ContinuityConfigScreen
extends Screen {
    private final Screen parent;
    private final ContinuityConfig config;
    private List<Value<?>> values;

    public ContinuityConfigScreen(Screen parent, ContinuityConfig config) {
        super((Component)Component.m_237115_((String)ContinuityConfigScreen.getTranslationKey("title")));
        this.parent = parent;
        this.config = config;
    }

    protected void m_7856_() {
        Value<Boolean> connectedTextures = Value.of(this.config.connectedTextures, Value.Flag.RELOAD_WORLD_RENDERER);
        Value<Boolean> emissiveTextures = Value.of(this.config.emissiveTextures, Value.Flag.RELOAD_WORLD_RENDERER);
        Value<Boolean> customBlockLayers = Value.of(this.config.customBlockLayers, Value.Flag.RELOAD_WORLD_RENDERER);
        this.values = List.of(connectedTextures, emissiveTextures, customBlockLayers);
        this.m_142416_((GuiEventListener)this.startBooleanValueButton(connectedTextures).m_252987_(this.f_96543_ / 2 - 100 - 110, this.f_96544_ / 2 - 10 - 12, 200, 20).m_253136_());
        this.m_142416_((GuiEventListener)this.startBooleanValueButton(emissiveTextures).m_252987_(this.f_96543_ / 2 - 100 + 110, this.f_96544_ / 2 - 10 - 12, 200, 20).m_253136_());
        this.m_142416_((GuiEventListener)this.startBooleanValueButton(customBlockLayers).m_252987_(this.f_96543_ / 2 - 100 - 110, this.f_96544_ / 2 - 10 + 12, 200, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
            this.saveValues();
            this.m_7379_();
        }).m_252987_(this.f_96543_ / 2 - 75 - 79, this.f_96544_ - 40, 150, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 75 + 79, this.f_96544_ - 40, 150, 20).m_253136_());
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.m_280273_(context);
        context.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 30, 0xFFFFFF);
        super.m_88315_(context, mouseX, mouseY, delta);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    private void saveValues() {
        EnumSet<Value.Flag> flags = EnumSet.noneOf(Value.Flag.class);
        for (Value<?> value : this.values) {
            if (!value.isChanged()) continue;
            value.saveToOption();
            flags.addAll(value.getFlags());
        }
        this.config.save();
        for (Value.Flag flag : flags) {
            flag.onSave();
        }
    }

    private static String getTranslationKey(String optionKey) {
        return "options.continuity." + optionKey;
    }

    private static String getTooltipKey(String translationKey) {
        return translationKey + ".tooltip";
    }

    private Button.Builder startBooleanValueButton(Value<Boolean> value) {
        String translationKey = ContinuityConfigScreen.getTranslationKey(value.getOption().getKey());
        MutableComponent text = Component.m_237115_((String)translationKey);
        MutableComponent tooltipText = Component.m_237115_((String)ContinuityConfigScreen.getTooltipKey(translationKey));
        return Button.m_253074_((Component)CommonComponents.m_178393_((Component)text, (Component)CommonComponents.m_130666_((boolean)value.get())), arg_0 -> ContinuityConfigScreen.lambda$startBooleanValueButton$3(value, (Component)text, arg_0)).m_257505_(Tooltip.m_257550_((Component)tooltipText));
    }

    private static /* synthetic */ void lambda$startBooleanValueButton$3(Value value, Component text, Button button) {
        boolean newValue = (Boolean)value.get() == false;
        value.set(newValue);
        Component valueText = CommonComponents.m_130666_((boolean)newValue);
        if (value.isChanged()) {
            valueText = valueText.m_6881_().m_130938_(style -> style.m_131136_(Boolean.valueOf(true)));
        }
        button.m_93666_((Component)CommonComponents.m_178393_((Component)text, (Component)valueText));
    }

    private static class Value<T> {
        private final Option<T> option;
        private final Set<Flag> flags;
        private final T originalValue;
        private T value;

        public Value(Option<T> option, Set<Flag> flags) {
            this.option = option;
            this.flags = flags;
            this.originalValue = this.option.get();
            this.value = this.originalValue;
        }

        public static <T> Value<T> of(Option<T> option, Flag ... flags) {
            EnumSet<Flag> flagSet = EnumSet.noneOf(Flag.class);
            Collections.addAll(flagSet, flags);
            return new Value<T>(option, flagSet);
        }

        public Option<T> getOption() {
            return this.option;
        }

        public Set<Flag> getFlags() {
            return this.flags;
        }

        public T get() {
            return this.value;
        }

        public void set(T value) {
            this.value = value;
        }

        public boolean isChanged() {
            return !this.value.equals(this.originalValue);
        }

        public void saveToOption() {
            this.option.set(this.value);
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static enum Flag {
            RELOAD_WORLD_RENDERER{

                @Override
                public void onSave() {
                    Minecraft.m_91087_().f_91060_.m_109818_();
                }
            };


            public abstract void onSave();
        }
    }
}

